#include "TFSSLCertificate.h"
#include "onion/DavSSLCertificateList.h"
#include "TFLibDefinition.h"

CTFSSLCertificate::CTFSSLCertificate(void)
{
	m_pSSLCert = NULL;
}

CTFSSLCertificate::~CTFSSLCertificate(void)
{
	if (m_pSSLCert) 
	{
		CDavSSLCertificateList* pCerts = (CDavSSLCertificateList*)m_pSSLCert;
		delete pCerts;
	}

	m_pSSLCert = NULL;
}

int
CTFSSLCertificate::SetCerts(void *pCerts)
{
	CDavSSLCertificateList* pSSLCerts = (CDavSSLCertificateList*)pCerts;
	if (pSSLCerts == NULL) return TF_FAIL;

	unsigned int nCnt = pSSLCerts->GetCount();
	if (nCnt == 0) return TF_FAIL;

	CDavSSLCertificateList* pOICerts = new CDavSSLCertificateList;
	CDavSSLCertificateData cData;

	void *pData = NULL;
	for(unsigned int unIndex=0; unIndex < nCnt; unIndex++)
	{
		(*pSSLCerts)[unIndex].Export(cData);
		pData = cData.GetData();
/*		if (pData != NULL)
			pOICerts->AddCertificate((const CDavSSLCertificate&)pData);
*/
	}

	m_pSSLCert = (void*)pOICerts;

	/* 検証 */
	if (((CDavSSLCertificateList*)m_pSSLCert)->GetCount() < 1) return TF_FAIL;

	return TF_TRUE;
}

unsigned int
CTFSSLCertificate::GetCertCount(void)
{
	unsigned int cnt = 0;

	if (m_pSSLCert)
	{
		cnt = ((CDavSSLCertificateList*)m_pSSLCert)->GetCount();
	}

	return cnt;
}

int
CTFSSLCertificate::GetCertData(unsigned int nIndex, void** pData, unsigned int* nDataLength)
{
	if (m_pSSLCert==NULL) return TF_FAIL;

	CDavSSLCertificateList* pCerts = (CDavSSLCertificateList*)m_pSSLCert;
	if (pCerts == NULL) return TF_FAIL;

	unsigned int cnt = pCerts->GetCount();
	if (cnt < nIndex) return TF_FAIL;

	CDavSSLCertificateData cData;
	(*pCerts)[nIndex].Export(cData);

	*pData = cData.GetData();
	*nDataLength = cData.GetDataLength();

	return (pData != NULL && nDataLength > 0);
}


void
CTFSSLCertificate::Clear(void)
{
	if (m_pSSLCert != NULL)
	{
		CDavSSLCertificateList* pCerts = (CDavSSLCertificateList*)m_pSSLCert;
		pCerts->Clear();
	}
}

void*
CTFSSLCertificate::GetCerts(void)
{
	return m_pSSLCert;
}

int
CTFSSLCertificate::SetCertificatesOnion(void)
{
	int nStoreCnt = 0;
	if (m_pSSLCert)
	{
		CDavSSLCertificateList* pCerts = (CDavSSLCertificateList*)m_pSSLCert;
		if (pCerts)
			nStoreCnt = LoadCertificates(pCerts);
	}

	return nStoreCnt;
}




