#include "TFServerResource.h"
#include "TFUtils.h"
#include "oimap.h"

#ifdef SetPort
#undef SetPort
#endif

#ifdef _DEBUG
//	static int gs_nTFServerItem = 0;
//	#define ADD_SVRITEM	gs_nTFServerItem++; TF_DEBUG("CTFServerResource::gs_nTFServerItem: %d\n", gs_nTFServerItem)
//	#define DEL_SVRITEM	gs_nTFServerItem--; TF_DEBUG("CTFServerResource::gs_nTFServerItem: %d\n", gs_nTFServerItem)
	#define ADD_SVRITEM
	#define DEL_SVRITEM
#else
	#define ADD_SVRITEM
	#define DEL_SVRITEM
#endif

TFLIB_IMPLEMENT_CLASS(CTFServerResource, "CTFServerResource")

CTFServerResource::CTFServerResource(void)
					:m_bUseSSL(false),
					m_bSkipLock(false),
					m_nHostPort(80),
					m_unSocketTimeout(0),
					m_bUseCompression(false)
{
	ADD_SVRITEM;
	TFLIB_CONSTRUCT_CLASS(CTFServerResource);
	m_enuType = TFITEM_SERVER;
}

CTFServerResource::~CTFServerResource(void)
{
	DEL_SVRITEM;
}

void 
CTFServerResource::Import(const CTFObject &source)
{

	TFLIB_PREPARE_IMPORT(CTFServerResource,CTFDavResource,source,psource);

	m_strServerID			= psource->m_strServerID;
	m_strUserID				= psource->m_strUserID;
	m_strPassWord			= psource->m_strPassWord;
	m_strHost				= psource->m_strHost;
	m_nHostPort				= psource->m_nHostPort;
	m_strProxyHost			= psource->m_strProxyHost;
	m_nProxyHostPort		= psource->m_nProxyHostPort;
	m_strProxyUserID		= psource->m_strProxyUserID;
	m_strProxyUserPassWord	= psource->m_strProxyUserPassWord;

	m_bSkipLock				= psource->m_bSkipLock;
	m_bUseSSL				= psource->m_bUseSSL;
	m_unSocketTimeout		= psource->m_unSocketTimeout;
	m_bUseCompression		= psource->m_bUseCompression;
	m_pSSLCert              = psource->m_pSSLCert;
}

bool
CTFServerResource::IsValid(void)
{
	if (
		(m_strHost.empty())		||
		(m_nHostPort < 0)		||
		(m_strUserID.empty())	||
		(m_strPassWord.empty())
	) return false;

	return true;
}

const TFXMLCh*	
CTFServerResource::GetUserID(void)
{
	return m_strUserID.c_str();
}

const TFXMLCh*	
CTFServerResource::GetPassWord(void)
{
	return m_strPassWord.c_str();
}

const TFXMLCh*
CTFServerResource::GetHost(void)
{
	return m_strHost.c_str();
}

int 
CTFServerResource::GetPort(void)
{
	return m_nHostPort;
}

const TFXMLCh* 
CTFServerResource::GetProxyHost(void)
{
	return m_strProxyHost.c_str();
}

int
CTFServerResource::GetProxyPort(void)
{
	return m_nProxyHostPort;
}

const TFXMLCh*
CTFServerResource::GetProxyUserID(void)
{
	return m_strProxyUserID.c_str();
}

const TFXMLCh*
CTFServerResource::GetProxyPassWord(void)
{
	return m_strProxyUserPassWord.c_str();
}

bool
CTFServerResource::GetOmitLockFlag(void)
{
	return m_bSkipLock;
}

bool
CTFServerResource::GetUseSSL(void)
{
	return m_bUseSSL;
}

unsigned int
CTFServerResource::GetSocketTimeout(void)
{
	return m_unSocketTimeout;
}

bool
CTFServerResource::GetUseCompression(void)
{
	return m_bUseCompression;
}

CTFSSLCertificate* 
CTFServerResource::GetSSLCertificate(void)
{
	return m_pSSLCert;
}

void
CTFServerResource::SetUserID(const TFXMLCh* pszUserID)
{
	m_strUserID = pszUserID;
}

void 
CTFServerResource::SetPassWord(const TFXMLCh* pszPassWord)
{
	m_strPassWord = pszPassWord;
}

void
CTFServerResource::SetHost(const TFXMLCh* pszHost)
{
	m_strHost = pszHost;
}

void
CTFServerResource::SetPort(int nPort)
{
	m_nHostPort = nPort;
}

void
CTFServerResource::SetProxyHost(const TFXMLCh* pszProxyHost)
{
	OI_ASSERT(pszProxyHost);
	m_strProxyHost = pszProxyHost;
}

void
CTFServerResource::SetProxyPort(int nPort)
{
	m_nProxyHostPort = nPort;
}

void 
CTFServerResource::SetProxyUserID(const TFXMLCh* pszProxyUserID)
{
	OI_ASSERT(pszProxyUserID);
	m_strProxyUserID = pszProxyUserID;
}

void 
CTFServerResource::SetProxyPassWord(const TFXMLCh* pszProxyPassWord)
{
	OI_ASSERT(pszProxyPassWord);
	m_strProxyUserPassWord = pszProxyPassWord;
}

void 
CTFServerResource::SetOmitLockFlag(bool bOmit)
{
	m_bSkipLock = bOmit;
}

void 
CTFServerResource::SetUseSSL(bool bUseSSL)
{
	m_bUseSSL = bUseSSL;
}
void
CTFServerResource::SetSocketTimeout(unsigned int unTimeout)
{
	m_unSocketTimeout = unTimeout;
}

void
CTFServerResource::SetUseCompression(bool bComplress)
{
	m_bUseCompression = bComplress;
}

void 
CTFServerResource::SetSSLCertificate(CTFSSLCertificate* pCert)
{
	m_pSSLCert = pCert;
}


