#include "TFStringTokenizer.h"

CTFStringTokenizer::CTFStringTokenizer(const TFXMLCh* pszInput, const TFXMLCh* pszDelimiters)
{
	m_strInput		= pszInput;
	m_pszIt			= m_strInput.begin();
	m_strDelimiter	= pszDelimiters;
	m_bInQuote		= false;
}

CTFStringTokenizer::~CTFStringTokenizer(void)
{
	m_strInput.erase();
	m_strDelimiter.erase();
}

bool 
CTFStringTokenizer::GetNextToken(TF_STRING_W& strValue)
{
	strValue.erase();
	bool bHasToken = false;

	for (; m_pszIt != m_strInput.end();)
	{
		if (*m_pszIt == *m_strDelimiter.begin())
			if (!m_bInQuote) 
			{
				m_pszIt++;
				return true;
			}

		if (*m_pszIt == 0x22)
			m_bInQuote = !m_bInQuote;

		strValue += *m_pszIt;
		bHasToken = true;

		m_pszIt++;
	}

	return bHasToken;
}


