#include "TFURL.h"
#include "oimap.h"

CTFURL::CTFURL(void)
{
	initialize();
}

CTFURL::CTFURL(const TFXMLCh* pszURL)
{
	parseURL(pszURL);
}

CTFURL::~CTFURL(void)
{
}

/**
 *	初期化する
 */
void CTFURL::initialize()
{
	m_bFolder = false;
	m_nPort = 0;
	m_strDir.erase();
	m_strHost.erase();
	m_strName.erase();
	m_strNamePrefix.erase();
	m_strNameSuffix.erase();
	m_strProtocol.erase();
	m_strURI.erase();
	m_strURL.erase();
}

/**
 *	URL(URI)を各要素に分離する
 *
 *	szURLにはURIを指定しても良い
 *
 */
bool
CTFURL::parseURL(const TFXMLCh* pszURL)
{
	int index1,index2s,index2;
	TF_STRING_W strURLwork;
	TF_STRING_W strHostPort;

	m_strProtocol = X("");
	m_strHost = X("");
	m_nPort = 0;
	m_strDir = X("");
	m_strName = X("");
	m_strURI = X("");
	m_bFolder = false;
	m_strNamePrefix = X("");
	m_strNameSuffix = X("");

	if( pszURL != NULL || !TF_STRING_W(pszURL).empty())
	{
		strURLwork = pszURL;
		TF_STRING_W strDelimiter = (const TFXMLCh*)X("://");
		index1 = (int)strURLwork.find(strDelimiter, 0);
		if( index1 >= 0 )
		{
			m_strURL = pszURL;
			m_strProtocol = strURLwork.substr(0, index1);

			index2s = index1 + (int)strDelimiter.length();
			index2 = (int)strURLwork.find(X("/"), index2s);
			if( index2 >= 0)
			{
				strHostPort = strURLwork.substr(index2s, index2 - index2s);
				parseHostnameAndPortNumber(strHostPort.c_str(), m_strHost, m_nPort);
				m_strURI = strURLwork.substr(index2);
			}
			else
			{
				strHostPort = strURLwork.substr(index2s);
				parseHostnameAndPortNumber(strHostPort.c_str(), m_strHost, m_nPort);
				return true;
			}
		}
		else if( *(strURLwork.begin()) != '/' )
		{
			parseHostnameAndPortNumber(strURLwork.c_str(), m_strHost, m_nPort);

		}

		// strURIが設定されていない場合はとりあえずワークのURIを設定する
		if (m_strURI.empty()) m_strURI = strURLwork.c_str();

		parseDirAndName(m_strURI.c_str(), m_strDir, m_strName, m_bFolder);

		return true;
	}
	else
	{
		return false;
	}
}

/**
 *	ホスト情報文字列から、「ホスト名」と「ポート番号」に分離する
 *
 *	"host:port"の文字列を、"host"と"port"に分離
 *
 */
bool
CTFURL::parseHostnameAndPortNumber(const TFXMLCh* pszHostPort, TF_STRING_W &strHostName, int &nPort)
{
	TF_STRING_W strNameStr = pszHostPort;
	TF_STRING_W strPort = (const TFXMLCh*)X("0");
	int index = (int)strNameStr.find(X(":"),0);
	if( index < 0 )
	{
		int index2 = (int)strNameStr.find(X("/"),0);
		if (index2 < 0)
		{
			strHostName = pszHostPort;
			nPort = 0;
		}
		else
		{
			strHostName = strNameStr.substr(0, index2);
			nPort = 0;
		}

		return (strHostName.empty());
	}
	else
	{
		strHostName = strNameStr.substr(0, index);
		int nPortTemp = atoi((const char*)X(strNameStr.substr(index+1).c_str()));
		if( (nPortTemp >= 0) && (nPortTemp <= 65535) )
		{
			nPort = nPortTemp;
		}
		else
		{
			nPort = 0;
		}

		return true;
	}
}


/**
 *	URI文字列から、「ディレクトリ」と「ファイル（フォルダ）名」に分離する
 *
 *	"/aaa/bbb/ccc/"の文字列を、"/aaa/bbb/"と"ccc"に分離
 *
 */
bool
CTFURL::parseDirAndName(const TFXMLCh* pszURI, TF_STRING_W &strDir, TF_STRING_W& strName, bool& bFolder)
{
	TF_STRING_W strURIwork = pszURI;
	strDir.erase();
	strName.erase();
	bFolder = false;

	if( *(strURIwork.end() - 1) == '/')
	{
		bFolder = true;
		if( strURIwork.length() == 1 )
		{
			strDir = strURIwork.c_str();
			return true;
		}
		else
		{
			strURIwork.erase((strURIwork.end()-1));
		}
	}
	else
	{
		bFolder = false;
	}
	
	int index = (int)strURIwork.rfind(X("/"));

	if( index >= 0 )
	{
		strDir = strURIwork.substr(0, index + 1).c_str();
		strName = strURIwork.substr(index + 1).c_str();
	}
	else
	{
		strName = strURIwork.c_str();
	}

	if (!strName.empty()) {
		index = (int)strName.find(X("."));
		if (index >= 0) {
			m_strNamePrefix = strName.substr(0, index + 1);
			m_strNameSuffix = strName.substr(index + 1);
		}
		else {
			m_strNamePrefix = strName.c_str();
			m_strNameSuffix = X("");
		}
	}

	return true;
}

bool
CTFURL::IsHTTP(void)
{
	return (m_strProtocol.compare(X("http")) == 0);
}

bool
CTFURL::IsHTTPS(void)
{
	return (m_strProtocol.compare(X("https")) == 0);
}

/**
 *	メンバー変数の内容を元に、URLを組み立ててメンバ変数m_szURLに格納する
 *
 *	bWithProtocolがTRUEの場合は、プロトコル部分(http://)を付加する
 *	bWithURIがTRUEの場合は、URI部分も組み立てる
 *
 */
bool 
CTFURL::BuildURL(bool bWithProtocol, bool bWithURI)
{
	m_strURL.erase();

	// プロトコル
	if( bWithProtocol )
	{
		if( m_strProtocol.empty() ) return false;
		m_strURL += m_strProtocol.c_str();
		m_strURL += (const TFXMLCh*)"://";
	}

	// ホスト名
	if( m_strHost.empty() ) return false;
	m_strURL += m_strHost.c_str();

	// ポート番号
	if( !(m_nPort == 0) 
//		&& !(IsHTTP() && (m_nPort == 80))
//		&& !(IsHTTPS() && (m_nPort == 443))
		)
	{
		char chPort[10];
		sprintf(chPort, ":%ld", m_nPort);
		m_strURL += (const TFXMLCh*)X(chPort);
	}

	// URI
	if( m_strURI.empty() )
	{
		// m_szURIが空の場合は、m_strDirとm_strNameからm_strURIを組み立てる
		m_strURI += m_strDir.c_str();
		m_strURI += m_strName.c_str();
		if( m_bFolder ) m_strURI += (const TFXMLCh*)X("/");
	}
	else
	{
		// m_strURIが空ではなく、かつm_strDirとm_strNameが空ではない場合は、
		// m_strURIからm_strDirとm_strNameを組み立てる
		if( m_strDir.empty() && m_strName.empty() )
		{		
			parseDirAndName(m_strURI.c_str(), m_strDir, m_strName, m_bFolder);
		}
	}

	if( bWithURI )
	{
		m_strURL += m_strURI.c_str();
	}

	return true;
}
