#include "TFUtils.h"
#include <onion/Utils.h>
#include "TFLibDefinition.h"
#include "TFServerManager.h"
#include "stdlib.h"
#include "TFString.h"

void 
TFInitialize(void)
{
	// Onionの初期化
	OnionInitialize();
	GetServerManager().Initialize();
};

void 
TFTerminate(void)
{
	GetServerManager().Terminate();

	// Onionの終了
	OnionTerminate();
};

#define TFTIMEFORMATISO8601	"%.4d-%.2d-%.2dT%.2d:%.2d:%.2dZ"
#define TFTIMEFORMATJAPAN	"%.4d/%.2d/%.2d %.2d:%.2d:%.2d"
bool FormatTime(TF_STRING_A& str, const char* pszFormat, const time_t t)
{
	bool bResult=false;
	str.erase();

	if (t)
	{
		const char* tmptz = NULL;
		struct tm* ttm = localtime(&t);
		char chBuf[128] = {0};
		sprintf(chBuf, pszFormat,	ttm->tm_year+ 1900,	// 年
									ttm->tm_mon + 1,		// 月
									ttm->tm_mday,			// 日
									ttm->tm_hour,			// 時
									ttm->tm_min,			// 分
									ttm->tm_sec);			// 秒

		str = chBuf;
		bResult = true;
	}

	return bResult;
}

bool
FormatTimeISO8601(TF_STRING_A& str, const time_t gmt)
{
	bool bResult = false;

	str.erase();
	if (time > 0)
	{
		const char* tmptz = NULL;

		struct tm* t = localtime(&gmt);
		char chBuf[128] = {0};
		sprintf(chBuf, "%.4d-%.2d-%.2dT%.2d:%.2d:%.2dZ",	t->tm_year+ 1900,	// 年
															t->tm_mon + 1,		// 月
															t->tm_mday,			// 日
															t->tm_hour,			// 時
															t->tm_min,			// 分
															t->tm_sec);			// 秒

		str = chBuf;
		bResult = true;
	}
	return bResult;
}

bool FormatTimeJapan(TF_STRING_A& str, const time_t t)
{
	return FormatTime(str, TFTIMEFORMATJAPAN, t);
}

void
GetToday(TF_STRING_A& strDate)
{

	time_t timer;
	time(&timer);

	struct tm* t = localtime(&timer);
	char chBuf[128] = {0};
	sprintf(chBuf, "%.4d/%.2d/%.2d %.2d:%.2d:%.2d",	t->tm_year+ 1900,	// 年
														t->tm_mon + 1,		// 月
														t->tm_mday,			// 日
														t->tm_hour,			// 時
														t->tm_min,			// 分
														t->tm_sec);			// 秒
	strDate = chBuf;

}

time_t ParseTimeJapan(const char* pszTime)
{
	struct tm jst = {0};
	int n;

	n = sscanf(pszTime, "%4d/%2d/%2d %2d:%2d:%2d",
				&jst.tm_year, &jst.tm_mon, &jst.tm_mday, &jst.tm_hour, &jst.tm_min, &jst.tm_sec);

	if (n!=6)
		return (time_t)-1;

	jst.tm_year -= 1900;
	jst.tm_mon--;
	jst.tm_isdst = -1;

	return mktime(&jst);

}

int
ParseMailWatchString(const char* pszMethod)
{
	int unMailWatch = TF_DAV_UNKNOWN;

	OI_STRING_A	strMethod = (const char*)X(pszMethod);

	if (strMethod.empty())
	{
		unMailWatch = TF_DAV_UNKNOWN;
	}
	else {
		CDavStringTokenizer cToken(strMethod.c_str());
		OI_STRING_A strField;
		for (;cToken.GetNextToken(strField);)
		{
			for (int i=0; TF_DAV_METHODTABLE[i].szMethod != NULL; i++)
			{
				if (strField.compare(TF_DAV_METHODTABLE[i].szMethod) == 0)
				{
					unMailWatch |= TF_DAV_METHODTABLE[i].iMethod;
				}
			}
		}
	}

	return unMailWatch;
};

void
BuildMailWatch(int nMethods, TF_STRING_W& strString)
{
	strString.erase();
	OI_STRING_A strStringA;

	for (int i=0; TF_DAV_METHODTABLE[i].iMethod != TF_DAV_UNKNOWN; i++)
	{
		if (nMethods & TF_DAV_METHODTABLE[i].iMethod)
		{
			strStringA += X(TF_DAV_METHODTABLE[i].szMethod);
			strStringA += X(" ");
		}
	}

	TrimLeftA(strStringA);
	TrimRightA(strStringA);

	strString = X(strStringA.c_str());
};

void
BuildAccessZone(int nZone, TF_STRING_W& strString)
{
	strString.erase();
	OI_STRING_A strStringA;

	// ゾーンがそもそも壊れている場合はさっさと終わる
	if (nZone & TF_ZONE_BROKEN) return;

	for (int i=0; TFACCESSZONETABLE[i].pszTagName != NULL; i++)
	{
		if (nZone & TFACCESSZONETABLE[i].nZone)
		{
			strStringA += X(TFACCESSZONETABLE[i].pszTagName);
			strStringA += X(" ");
		}
	}

	TrimLeftA(strStringA);
	TrimRightA(strStringA);

	strString = X(strStringA.c_str());
}

bool GetFinalPathSegment(const TFXMLCh* pszURI, TF_STRING_W& strName)
{
	bool bResult = false;
	if (IS_EMPTY(pszURI)) return false;

	TF_STRING_W strURI = pszURI;
	int nLen = (int)strURI.size();
	if (nLen < 1) return false;

	TF_STRING_W::size_type npos = strURI.rfind(C2W("/"), nLen-2);
	if (npos != TF_STRING_W::npos)
	{
		strName = strURI.substr(npos+1, nLen-1);
		bResult = true;
	}

	return bResult;

}

void
RemoveDoubleSlashA(TF_STRING_A& strPath)
{
	if (strPath.empty()) return;

	// 連続のスラッシュがない場合は細かく調べずすぐ終わる
	if (strPath.find("//") == TF_STRING_A::npos) return;

	TF_STRING_A strTmp;

	strTmp = strPath;
	TF_STRING_A::size_type pos;
	TF_STRING_A strSlush = "/";
	while((pos = strTmp.find("//")) != TF_STRING_A::npos)
	{
		strTmp.erase(pos, strSlush.length());
	}

	strPath.erase();
	strPath = strTmp;
	
}

void
RemoveDoubleSlashW(TF_STRING_W& strPath)
{
	if (strPath.empty()) return;

	// 連続のスラッシュがない場合は細かく調べずすぐ終わる
	if (strPath.find(C2W("//")) == TF_STRING_W::npos) return;

	TF_STRING_W strTmp;
	TF_STRING_W::iterator it = strPath.begin();

	strTmp = strPath;
	TF_STRING_W::size_type pos;
	TF_STRING_W strSlush = C2W("/");
	while((pos = strTmp.find(C2W("//"))) != TF_STRING_W::npos)
	{
		strTmp.erase(pos, strSlush.length());
	}

	strPath.erase();
	strPath = strTmp;	
}

void
TFDebugPrint(const char* pszFormat, ...)
{
	va_list va;
	va_start(va, pszFormat);
	vfprintf(stderr, pszFormat, va);
	va_end(va);

}

void
RemoveSlash(TF_STRING_W& strURI)
{
	if ((strURI.size()) > 0)
	{
		if (strURI[strURI.size() -1] == '/')
		{
			strURI.erase(strURI.size() -1);
		}
	}
}

