#include "TFWsNotificationHandler.h"
#include "TFLibPublic.h"
#include "TFUtils.h"

CTFWsNotificationHandler::CTFWsNotificationHandler(void)
{
}

CTFWsNotificationHandler::~CTFWsNotificationHandler(void)
{
}

/**
 * OnAuthenticateNotify
 * 認証画面を出すためのハンドラ
 *
 * (note)
 *		pszRealmにてサーバからのメッセージを画面に表示することができます。
 *		ユーザIDをパスワードを与えてTRUEを戻すと認証を行なってくれます。
 *		falseを返すと内容に関わらず認証失敗します。
 *
 *	@param	pszRealm		const char*		サーバの認証する為の文字列
 *	@param	strUsername	TF_STRING_A&		ユーザ名（ID)
 *	@param	strPasswd		TF_STRING_A&		パスワード
 *	@param	nRetry			int					認証回数
 *	@param	enuAuthClass	TF_AUTH_CLASS		認証種別
 *
 *	@return boolean		true: 成功 / false: 失敗
 */
bool
CTFWsNotificationHandler::OnAuthenticateNotify(const char* pszRealm, TF_STRING_A& strUsername,
							TF_STRING_A& strPasswd, int nRetry, TF_AUTH_CLASS enuAuthClass)
{
	TF_DEBUG("CTFWsNotificationHandler::OnAuthenticateNotify\r\n");

	return false;
}

/**
 *	OnQueryRetryCount
 *	認証を行なっていい回数か判断してもらうハンドラ
 *
 *	@param		nRetry			int				認証回数
 *	@param		enuAuthClass	OI_AUTH_CLASS	認証種別
 *	@return	boolean		true: 認証許可	 / false: 認証だめ
 */
bool
CTFWsNotificationHandler::OnQueryAuthRetryCount(int nRetry, TF_AUTH_CLASS enuAuthClass)
{
	return true;
}

/**
 *	OnNotifyMessage
 *	エラーメッセージを表示するためのハンドラ
 *
 *	(note)
 *		ここで渡されてくるエラーコードに対するダイアログの処理や
 *		必要なボタンの種類をつかってダイアログなどを作成して、ユーザの押された結果
 *		を返却するように実装してください。
 *
 *	@param		enuResult		TFRESULT		エラーコード
 *	@param		nNotifyType	int				表示しなければならない選択ボタン
 *	@return	TFDLGNOTIFYTYPE				戻ってきたボタンのタイプ
 *
 */
TFDLGNOTIFYTYPE 
CTFWsNotificationHandler::OnNotifyMessage(TFRESULT enuResult, int nNotifyType, CTFResourceItemList* pItemList)
{
	return TF_DLG_NOTIFY_NONE;
}

/**
 *	プログレスのウィンドウを表示などして欲しい場合に呼ばれるハンドラです。
 */
bool 
CTFWsNotificationHandler::OnInitializeProgressWindow(void **handle, TFTRANSMODE enuMode)
{
	TF_DEBUG("CTFWsNotificationHandler::OnInitializeProgressWindow\n");

	return false;
}

bool 
CTFWsNotificationHandler::OnPreSendProgressWindow(const TFXMLCh* str, TFHANDLE hHandle)
{
	TF_DEBUG("CTFWsNotificationHandler::OnPreSendProgressWindow()\n");
	return false;
}

/**
 *	プログレスのウィンドウを更新する為に呼ばれるハンドラです。
 */
bool
CTFWsNotificationHandler::OnUpdateProgressWindow(const TFXMLCh* str, void *handle, TF_SIZE_T unProgress, TF_SIZE_T unTotal)
{
	TF_DEBUG("CTFWsNotificationHandler::OnUpdateProgressWindow()\n");

	return false;
}

/**
 *	プログレスのウィンドウの終了処理のときに呼ばれるハンドラです。
 *
 */
bool
CTFWsNotificationHandler::OnTerminateProgressWindow(void *handle)
{
	TF_DEBUG("CTFWsNotificationHandler::OnTerminateProgressWindow\r\n");

	return false;
}

void 
CTFWsNotificationHandler::OnResultServerType(const int nAllowMethods, const int nAllowDASL)
{
}

bool
CTFWsNotificationHandler::OnNotifySSLCerts(CTFSSLCertificate* pCerts) const
{
	return true;
}
