#include "TFWsSystemInformationHandler.h"
#include "TFServerResource.h"
#include "oimap.h"

#ifdef _WIN32
#include <windows.h>
#include <Lmcons.h>
#endif

CTFWsSystemInformationHandler::CTFWsSystemInformationHandler(void)
{
}

CTFWsSystemInformationHandler::~CTFWsSystemInformationHandler(void)
{
}

bool 
CTFWsSystemInformationHandler::OnRequestConfigPath(TFSETTINGXMLTAG enuTag, TF_STRING_W& strFilePath)
{
	if (enuTag == TFSETTINGXMLTAG_POLICY)
	{
#ifdef _WIN32
		LPTSTR pszPath;
		pszPath = new TCHAR[MAX_PATH];
		memset(pszPath, NULL, MAX_PATH);
		if (::GetModuleFileName(NULL, pszPath, MAX_PATH))
		{
			::PathRemoveFileSpec(pszPath);
			strFilePath = X(pszPath);
		}
		delete [] pszPath;
		strFilePath += X("\\policy.xml");
#else
		// TODO: fullパスでいいのかしら
		strFilePath = X("/usr/local/teamfile/lib/policy.xml");
#endif
		return true;
	}

	return false;
}

void 
CTFWsSystemInformationHandler::OnRequestUserAgentName(TF_STRING_A& strUserAgent)
{
	strUserAgent = TF_DEFAULT_USER_AGENT;
}

bool
CTFWsSystemInformationHandler::OnRequestServerItemList(CTFResourceItemList** pItemList)
{
	return false;
}

void
CTFWsSystemInformationHandler::OnQueryHasSSLCertificate(TF_SSL_CERT_HANDLE_TYPE& enuHandle)
{
	enuHandle = TF_SSL_CERT_UNKNOWN;
}

bool
CTFWsSystemInformationHandler::OnOpenSystemStore(TF_SSL_CERT_STORE_NAME enuStoreName, TFHANDLE pHandle)
{
	return false;
}

bool
CTFWsSystemInformationHandler::OnLoadCertsStore(TFHANDLE pHandle, CTFSSLCertificate** pSSLCert)
{
	return false;
}

bool
CTFWsSystemInformationHandler::OnSaveCertStore(TFHANDLE pHandle, void *pData, unsigned int unLength)
{
	return false;
}

bool
CTFWsSystemInformationHandler::OnCloseCertsStore(TFHANDLE pHandle)
{
	return false;
}

void
CTFWsSystemInformationHandler::OnQuerySymmetricKey(TF_STRING_A &strKey, const CTFObject* pHintObj)
{
#ifdef _WIN32
	CTFServerResource* pSvrItem = TFLIB_DYNAMIC_CAST(CTFServerResource, (CTFObject*)pHintObj);
	if (pSvrItem != NULL)
	{
		TCHAR	szBuff[UNLEN+1]; 
		DWORD	dwBuff = UNLEN+1;
		LPTSTR	lpszUserName = szBuff;
//		if (::GetUserName(lpszUserName, &dwBuff))
//
	}
#endif

}

bool
CTFWsSystemInformationHandler::OnSetConfigurationFilePath(CTFLocalFileItem& rItem)
{
	return false;
}




