#include "TFWsTransactionHandler.h"
#include "TFPlatformsFactory.h"
#include "TFLocalFileUtils.h"
#include "TFDavResource.h"
#include "TFUtils.h"
#include "onion/Utils.h"

CTFWsTransactionHandler::CTFWsTransactionHandler(void)
{
	m_nFeature = TF_TRANS_FEATURE_NONE;
}

CTFWsTransactionHandler::~CTFWsTransactionHandler(void)
{
}

void
CTFWsTransactionHandler::OnTransLangMode(TFLANG& enuLang)
{

	enuLang = TF_LANG_UNKNOWN;		// デフォルトをセット

#ifdef _WIN32
	LCID lcid = GetUserDefaultLCID();

	// LCIDよりロケールを設定する。
	switch(lcid)
	{
		case 1041:		// 日本語
			enuLang = TF_LANG_JA;
		default:
			break;
	}

#else

#endif

}

void
CTFWsTransactionHandler::OnRequestAddHeader(TF_STRING_STRING_MAP mapHeader)
{
}

void
CTFWsTransactionHandler::OnRequestLicense(TF_STRING_A &strLicense)
{
	strLicense = "";
}

bool 
CTFWsTransactionHandler::OnQueryNewResourceName(TFRESOURCETYPE enuType, TFTRANSMODE enuMode, TF_STRING_A& strName, int nRetry)
{

	if (nRetry > 2) return false;

	if (enuMode == TF_TRANS_MAKEFOLDER)
	{
		switch(enuType)
		{
			case TF_RES_FILE:
				strName = "New File";
				break;

			case TF_RES_COLLECTION:
				strName = "New Folder";
				break;

			default:
				break;
		}
	}

	if (enuMode == TF_TRANS_RENAME)
	{

	}

	return true;
}

bool
CTFWsTransactionHandler::OnUseDAVCLASS2(void)
{
	return true;
}

bool 
CTFWsTransactionHandler::OnShowResource(CTFResourceItem* pItem)
{
	return true;
}

bool 
CTFWsTransactionHandler::OnQueryAcceptItem(TFITEMTYPE enuType)
{
	// 全てTRUEで戻します。（デフォルトの動作）

	bool	bResult;

	switch(enuType)
	{
		case TFITEM_DBLINK_ROOT:
		case TFITEM_REPOSDB_ROOT:
		case TFITEM_MNG_ROOT:
		default:
			bResult = true;
	}

	return bResult;
}

bool
CTFWsTransactionHandler::OnQueryIdentifier(const TFTRANSMODE enuMode, TF_STRING_W& strIdent,const int nLength, int nRetry)
{
	return false;
}

bool
CTFWsTransactionHandler::OnQuerySelectedItems(TFDAVMETHOD enuMethod, TFTRANSMODE enuMode, CTFResourceItemList& pItemList)
{
	return false;
}

void
CTFWsTransactionHandler::OnResultDAVMethod(const int nOI_RESULT, const TFXMLCh* pszURI, TFDAVMETHOD enuMethod)
{
}

void
CTFWsTransactionHandler::OnQuerySystemMessage(const TF_STRING_W strIdent, TF_STRING_W& strMessage, bool& bActive)
{
}

bool
CTFWsTransactionHandler::OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod)
{
	return true;
}

void
CTFWsTransactionHandler::OnSetSystemPath(CTFLocalFileItem* pItem, int nType)
{
}

void
CTFWsTransactionHandler::OnResultLocalResource( const TFTRANSMODE enuMode,
												const TFDAVMETHOD enuMethod, 
													   CTFLocalFileItem* pItem,
												const TFRESULT nResult)
{
}

bool 
CTFWsTransactionHandler::OnQueryRecursiveLocalResource(TF_SIZE_T unStratum,
													   CTFLocalFileItem* pItem)
{
	return true;
}

bool
CTFWsTransactionHandler::OnQueryDownloadItem(CTFLocalFileItem* pItem, CTFResourceItem* pHint)
{
	return false;
}

void
CTFWsTransactionHandler::SetErrorCodeNative(TF_SIZE_T nCode, TF_TRANS_ERROR_TYPE enuType, CTFObject* pObj)
{
	if (!(m_nFeature & TF_TRANS_FEATURE_DEBUG)) return;

	TF_STRING_A strMessage;
	TF_STRING_A strDate;
	TF_STRING_A strOUT;
	char chCode[20];

	// 本日日付の取得
	GetToday(strDate);

	TF_STRING_A strTarget;
	// エラーコードを設定する
	sprintf(chCode,"%lld: ", nCode);

	switch(enuType)
	{
		// ローカルシステムによるエラー
		case CTFWsTransactionHandler::TF_TRANS_ERROR_TYPE_LOCAL:
			strTarget = "[LOCAL] ";
			{
				CTFLocalFileItem* pItem = TFLIB_DYNAMIC_CAST(CTFLocalFileItem, pObj);
				if (pItem)
				{
					strTarget += pItem->GetPathA();
					CTFPlatformsFactory* pFactory = new CTFPlatformsFactory();
					CTFLocalFileUtils* pUtils = pFactory->CreateLocalFileUtils();
					// エラーメッセージを設定する
					pUtils->GetErrorMessage(nCode, strMessage);
					if (pUtils) delete pUtils;
					if (pFactory) delete pFactory;
				}
			}
			break;

		case CTFWsTransactionHandler::TF_TRANS_ERROR_TYPE_NET:
			strTarget = "[NET]   ";
			{
				CTFDavResource* pItem = TFLIB_DYNAMIC_CAST(CTFDavResource, pObj);
				if (pItem)
				{
					strTarget += (const char*)X(pItem->GetURI());
				}
				strMessage = GetErrorDescription((OI_RESULT)nCode);
			}
			break;

	}

	// 体裁を整える
	TF_STRING_A szExtString;
	if (OnDebugExtString(szExtString) == true) { 
		strOUT = "[" + strDate + "] " + "[" + szExtString.c_str() + "] "+ chCode + strMessage + " " + strTarget + CRLF;
	}
	else {
		strOUT = "[" + strDate + "]  " + chCode + strMessage + " " + strTarget + CRLF;
	}
	OnDebugPrint(strOUT.c_str());


}

bool
CTFWsTransactionHandler::OnDebugExtString(TF_STRING_A& szExtString)
{
	return false;
}

void
CTFWsTransactionHandler::OnDebugPrint(const char* pszString)
{
	// 標準エラーの出力
	if (pszString != NULL) fprintf(stderr, pszString);
}

void
CTFWsTransactionHandler::SetFeature(TF_TRANS_FEATURE_TYPE enuType, bool bSwitch)
{
	if (bSwitch)
		m_nFeature |= enuType;
	else
		m_nFeature  = m_nFeature & ~(enuType);
}

bool
CTFWsTransactionHandler::GetFeature(TF_TRANS_FEATURE_TYPE enuType)
{
	return ((m_nFeature & enuType)?true:false);
}
