#include <stdio.h>
#include "onion/Utils.h"
#include "TFXMLErrorHandler.h"

CTFXMLErrorHandler::CTFXMLErrorHandler(void)
{
}

CTFXMLErrorHandler::~CTFXMLErrorHandler(void)
{
}

//***************************************************************************
/**
 *	パーサーなどの処理中に致命的エラーが発生した場合に実行されるハンドラ。
 *	このハンドラは、エラーをデバッグメッセージに表示後、そのままre-throwする。
 *
 *	@param	&exception	XNS(SAXParseException)	例外オブジェクト
 *
 */
void CTFXMLErrorHandler::fatalError(const XNS(SAXParseException) &exception)
{
	const XMLCh* msg = exception.getMessage();
	const XMLCh* pubid = exception.getPublicId();
	const XMLCh* sysid = exception.getSystemId();
	unsigned long col = exception.getColumnNumber();
	unsigned long row = exception.getLineNumber();
	printf("Xerces-C Fatal Error!\n\tMessage: %s\n\tPublicID: %s\n\tSystemID: %s\n\tLine %d, Column %d\n", (const char*)X(msg), (const char*)X(pubid), (const char*)X(sysid), col, row);

	// 例外をスローする
	throw exception;
}

void CTFXMLErrorHandler::error(const XNS(SAXParseException) &exception)
{
}

