#include "TFXMLServerSettings.h"
#include "TFServerResource.h"
#include "oimap.h"

CTFXMLServerSettings::CTFXMLServerSettings(void)
{
	m_pSysHandler = &m_cSysHandler;
}

CTFXMLServerSettings::~CTFXMLServerSettings(void)
{
}


/**
 *	ファイルパスによってXMLをロードする
 *
 *	@param	pszFilePath	const char*
 *	@return bool
 */
bool
CTFXMLServerSettings::LoadXML(TFSETTINGXMLTAG enuType, const TFXMLCh* pszFilePath)
{

	OI_STRING_A strPath;

	if (IS_EMPTY(pszFilePath) || TF_STRING_W(pszFilePath).empty())
		return false;

	if (Load(pszFilePath) == false) return false;

	CreateServerDOMDocument(TFSETTINGXMLTAG_SERVER, NULL);
	return ParseXML(enuType);
}

/**
 *	XMLをパースする
 *	@param enuTag		TFSETTINGXMLTAG		パースするタグ
 *	@return boolean
 */
bool 
CTFXMLServerSettings::ParseXML(TFSETTINGXMLTAG enuTag)
{
	TF_STRING_W	strNameW, strNSURIW;
	XNS(DOMElement)* pRootNode = GetRootElement();
	GetElementName(pRootNode, strNameW, strNSURIW);

	if (pRootNode)
	{
		QueryParser(enuTag, pRootNode);
		return true;
	}

	return false;

}

/**
 *	XMLをパースすることができるハンドラを追加する
 *	@param	enuTag		TFSETTINGXMLTAG
 *	@param	pHandler	CTFXMLTagBase*
 */
void
CTFXMLServerSettings::AddHandler(TFSETTINGXMLTAG enuTag, CTFXMLTagBase *pHandler)
{
	m_pTagHandlerMap.insert(MMAPTAGPAIR(enuTag, pHandler));
}

/**
 *	システムハンドラを登録する
 *	@param	pHandler	CTFWsSystemInformationHandler*
 */
void
CTFXMLServerSettings::SetSystemInfoHandler(CTFWsSystemInformationHandler* pHandler)
{
	m_pSysHandler = pHandler;
}

/**
 *	登録されているパーサの種類によって処理を依頼する
 *	@param	enuTag		TFSETTINGXMLTAG
 *	@param	pElement	DOMElement*
 */
void 
CTFXMLServerSettings::QueryParser(TFSETTINGXMLTAG enuTag, XNS(DOMElement)* pElement)
{
	OI_ASSERT(pElement);

	CTFXMLTagBase* pTag = NULL;

	// ステージとして設定されたものがあるか調べる
	if (!hasTagHandler(enuTag)) return;

	MMAPTAGHANDLER::iterator it	= m_pTagHandlerMap.find(enuTag);
	while(it != m_pTagHandlerMap.end())
	{
		it->second->SetHandler(m_pSysHandler);
		it->second->OnParseXML(pElement);
		it++;
	}
}

bool
CTFXMLServerSettings::CreateServerDOMDocument(TFSETTINGXMLTAG enuTag, CTFServerResource* pSvrItem)
{
	XNS(DOMNodeList)* pNodes = GetRootElement()->getChildNodes();

	int nCount = (int)pNodes->getLength();

	XNS(DOMNode)* pNode;
	TF_STRING_W strName, strNSURL;
	for (int i=0; i < nCount; i++)
	{
		strName.erase();
		strNSURL.erase();
		pNode = pNodes->item(i);
		if (!GetElementName((XNS(DOMElement)*)pNode, strName, strNSURL)) continue;
		MMAPTAGHANDLER::iterator it	= m_pTagHandlerMap.find(enuTag);
		while(it != m_pTagHandlerMap.end())
		{
			if (it->second->HasElementName(X(strName.c_str())))
			{
				it->second->SetHandler(m_pSysHandler);
			}

			it++;
		}
	}

	return true;
}

/**
 *	登録されているタグのマップから引数の種類が登録されているかを調べる
 *
 *	@param	enuTag		TFSETTINGXMLTAG
 *	@return boolean
 */
bool
CTFXMLServerSettings::hasTagHandler(TFSETTINGXMLTAG enuTag)
{
	int nCount = (int)m_pTagHandlerMap.count(enuTag);

	return (nCount > 0);
}
