
#include "TFXMLTagServer.h"
#include "TFMemory.h"

#ifdef HAVE_LIBTFCRYPT
#include "libtfcrypt/libtfcrypt.h"
#endif

#ifdef SetPort
#undef SetPort
#endif
#include "TFServerResource.h"

CTFXMLTagServer::CTFXMLTagServer(const char* pszChageElementName)
				:CTFXMLTagBase(pszChageElementName)
{
	m_pItemList = new CTFDavResourceList;
}

CTFXMLTagServer::~CTFXMLTagServer(void)
{
	if (m_pItemList != NULL) delete m_pItemList;
}

CTFDavResourceList*	
CTFXMLTagServer::GetServerItemList(void)
{
	return m_pItemList;
}

bool
CTFXMLTagServer::OnParseXML(XNS(DOMElement)* pElement)
{
	OI_ASSERT(pElement);

	// ロケーション設定がいくつあるか数える
	int nSvrCnt = GetElementCount(pElement, C2W(m_strChargeElement.c_str()));
	if (nSvrCnt == 0) return false;

	for (int i=0; nSvrCnt > i; i++)
	{
		CTFServerResource *pSvrResource = new CTFServerResource;

		OI_STRING_A strName, strNSURI;
		XNS(DOMElement)* pNode;
		TF_STRING_W strText;

		// サーバ名（ServerID)
		// サーバIDが存在しない場合は
		// 本当ならリソースを作るべきではないでしょう。
		pNode = GetElement(pElement, C2W("name") , i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				pSvrResource->SetServerID(strText.c_str());
			}
			else {
				OI_ASSERT(false);
			}
		}
		else {
			OI_ASSERT(false);
		}

		// ホスト名
		pNode = GetElement(pElement, C2W("hostname"), i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				pSvrResource->SetHost(strText.c_str());
			}
		}

		// URI
		pNode  = GetElement(pElement, C2W("uri"), i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				pSvrResource->SetURI(strText.c_str());
			}
		}
		
		// ポート番号
		pNode = GetElement(pElement, C2W("port"), i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				pSvrResource->SetPort(atoi(X(strText.c_str())));
			}
		}

		// SSLの利用可否
		pNode = GetElement(pElement, C2W("usessl"), i);
		if (pNode)
		{
			pSvrResource->SetUseSSL(true);
		}

		// ユーザID
		pNode = GetElement(pElement, C2W("username"), i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				pSvrResource->SetUserID(strText.c_str());
			}
		}

		// ソケットタイムアウト
		pNode = GetElement(pElement, C2W("sockettimeout"), i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				pSvrResource->SetSocketTimeout(atoi(X(strText.c_str())));
			}
		}

		// エージェントの初期起動可否
		pNode = GetElement(pElement, C2W("subscribewithagent"), i);
		if (pNode)
		{
			// #### TODO: エージェントの起動
		}

		// ロックシーケンスの利用可否
		pNode = GetElement(pElement, C2W("OmitLockOperation"), i);
		if (pNode)
		{
			pSvrResource->SetOmitLockFlag(true);
		}

		// 圧縮要求の可否
		pNode = GetElement(pElement, C2W("requestdatacompression"), i);
		if (pNode)
		{
			pSvrResource->SetUseCompression(true);
		}

		// アイテムの名前を設定する サーバIDを同じにする
		pSvrResource->SetName(pSvrResource->GetServerID());

		// パスワード
		// パスワードは暗号化の処理を行なう為に最後に設定してあります。
		// この場所を絶対に変えないようにしてください。
		pNode = GetElement(pElement, C2W("password"), i);
		if (pNode)
		{
			if (GetText(pNode, strText))
			{
				TF_STRING_W	strPassWord = strText;

#ifdef HAVE_LIBTFCRYPT
				OI_STRING_A strTmpPW = (const char*)X(strPassWord.c_str());
				OI_STRING_A	strKey;

				// 対象キーを問い合わせる
				m_pSysHandler->OnQuerySymmetricKey(strKey, pSvrResource);

				int nSize = tf_crypt_base64_decode_len((int)strTmpPW.size());
				int nOutlen = 0;

				if (nSize)
				{
					char* pchb64After = new char[nSize];
					if (pchb64After)
					{
						// BASE64をデコードする
						int nCipherlen = tf_crypt_base64_decode(pchb64After, strTmpPW.c_str(), (int)strTmpPW.size());
						if (nCipherlen)
						{
							char* pchOut = new char[nCipherlen+1];
							if (pchOut)
							{
								// 複合化 = 2
								if (tf_crypt_string(pchOut, &nOutlen, pchb64After, nSize, strKey.c_str(), 2))
								{
									strPassWord = C2W(pchOut);
								}
								delete[] pchOut;
							}
						}
						delete [] pchb64After;
					}
				}
#endif
				pSvrResource->SetPassWord(strPassWord.c_str());
			}
		}

		m_pItemList->AddItem(pSvrResource);

	}

	return true;

}
