#include "TFXmlBodyBuilder.h"
#include "TFUtils.h"
#include "oimap.h"

CTFXmlBodyBuilder::CTFXmlBodyBuilder(void)
{
	m_lpLast = NULL;
}

CTFXmlBodyBuilder::~CTFXmlBodyBuilder(void)
{
}

XNS(DOMElement)* 
CTFXmlBodyBuilder::GetLastElement(void)
{
	return m_lpLast;
}

XNS(DOMElement)*
CTFXmlBodyBuilder::GetElementByName(const TFXMLCh* Name)
{
	return GetElement(GetRootElement(), Name, 0, C2W(TF_XML_NSURI));
}

bool
CTFXmlBodyBuilder::AddPropSet(void)
{
	OI_ASSERT(m_lpLast == NULL);

	XNS(DOMElement)* lpRoot = GetRootElement();
	if (lpRoot == NULL) return false;

	XNS(DOMElement)* lpSet = AppendElement(lpRoot, C2W("set"), C2W(TF_DAV_XML_NSURI), C2W(DAV_XML_NAMESPACE_PREFIX));

	if (lpSet)
		m_lpLast  = AppendElement(lpSet, C2W("prop"), C2W(TF_DAV_XML_NSURI), C2W(DAV_XML_NAMESPACE_PREFIX));

	return (m_lpLast != NULL);
}

bool
CTFXmlBodyBuilder::AddPropRemove(void)
{
	OI_ASSERT(m_lpLast == NULL);

	XNS(DOMElement)* lpRoot = GetRootElement();
	if (lpRoot == NULL) return false;

	XNS(DOMElement)* lpRemove = AppendElement(lpRoot, C2W("remove"), C2W(TF_DAV_XML_NSURI), C2W(DAV_XML_NAMESPACE_PREFIX));

	if (lpRemove)
		m_lpLast  = AppendElement(lpRemove, (const TFXMLCh*)X("prop"), C2W(TF_DAV_XML_NSURI), C2W(DAV_XML_NAMESPACE_PREFIX));

	return (m_lpLast != NULL);
}

bool 
CTFXmlBodyBuilder::AddPropChild(const TFXMLCh* pszElementName, const TFXMLCh* pszNSURI, const TFXMLCh* pszNSPrefix)
{
	OI_ASSERT(pszElementName);

	XNS(DOMElement)* lpParent=NULL;
	if (m_lpLast == NULL)
	{
		lpParent = GetRootElement();
	}
	else
	{
		lpParent = m_lpLast;
	}
	
	if (lpParent == NULL) return false;
	
	m_lpLast = AppendElement(lpParent, pszElementName, pszNSURI, pszNSPrefix);
	
	return (m_lpLast != NULL);
}

bool 
CTFXmlBodyBuilder::AddPropSibling(const TFXMLCh* pszElementName,
								  const TFXMLCh* pszNSURI,
								  const TFXMLCh* pszNSprefix)
{
	OI_ASSERT(pszElementName);
	
	XNS(DOMElement)* lpParent=NULL;
	if (m_lpLast == NULL)
	{
		lpParent = GetRootElement();
	}
	else
	{
		lpParent = m_lpLast;
	}
	
	XNS(DOMElement)* pDummy = AppendElement(lpParent, pszElementName, pszNSURI, pszNSprefix);
	
	return (pDummy != NULL);						
}

bool
CTFXmlBodyBuilder::AddPropDiscovery(TF_PROP_DISCOVERY enuType)
{
	OI_ASSERT(m_lpLast);

	for (int i=0; TFDASLTABLE[i].enuTypeDiscovery != TF_PROP_DISCOVERY_UNKNOWN; i++)
	{
		if (TFDASLTABLE[i].enuTypeDiscovery == enuType)
		{
			m_lpLast = AppendElement(m_lpLast, C2W(TFDASLTABLE[i].pszDiscoveryName), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
			if (m_lpLast)
				m_lpLast = AppendElement(m_lpLast, C2W(TFDASLTABLE[i].pszInfoSub), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

			break;	// 一度見つかればよい
		}
	}

	return (m_lpLast != NULL); 
}

bool 
CTFXmlBodyBuilder::AddPropSearch(TFSEARCHTYPE enuType)
{
	OI_ASSERT(m_lpLast == NULL);

	XNS(DOMElement)* lpRoot = GetRootElement();
	if (lpRoot == NULL) return false;

	for (int i=0; TFDASLTABLE[i].enuTypeSearch != TF_DASL_UNKNOWN; i++)
	{
		if (TFDASLTABLE[i].enuTypeSearch == enuType)
		{
			m_lpLast = AppendElement(lpRoot, C2W(TFDASLTABLE[i].pszSearchName), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

			break;	// 一度見つかればよい
		}
	}
	
	return (m_lpLast != NULL);
}

bool 
CTFXmlBodyBuilder::AddPropSearchMode(TF_SEARCH_MODE enuMode)
{
	OI_ASSERT(m_lpLast);
	XNS(DOMElement)* pNode = NULL;

	for (int i=0; TFSEARCHMODETABLE[i].enuMode != TF_SEARCH_MODE_UNKNOWN; i++)
	{
		if (TFSEARCHMODETABLE[i].enuMode == enuMode)
		{
			pNode = AppendElement(m_lpLast, C2W(TFSEARCHMODETABLE[i].pszName), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

			break;	// 一度見つかればよい
		}
	}
	
	return (pNode != NULL);
}

bool
CTFXmlBodyBuilder::Initialize(const TFXMLCh* pszRootNodeName, const TFXMLCh* pszNSURI, const TFXMLCh* pszNSPrefix, const TFXMLCh* pszNsltURL)
{
	OI_ASSERT(pszRootNodeName);
	bool bResult;
	TF_STRING_W	strNSURI, strNSPrefix;;

	XNS(DOMElement)* pRoot = GetRootElement();
	if (pRoot) Destroy();

	if (pszNSURI != NULL)
	{
		strNSURI = pszNSURI;
	}
	else
	{
		strNSURI += C2W(TF_DAV_XML_NSURI);
	}

	if (pszNSPrefix != NULL)
	{
		strNSPrefix = pszNSPrefix;
	}
	else 
	{
		strNSPrefix = C2W(DAV_XML_NAMESPACE_PREFIX);
	}

	// ドキュメントを作成する
	bResult = Create(pszRootNodeName, strNSURI.c_str(), strNSPrefix.c_str(), pszNsltURL);

	return bResult;
}

bool 
CTFXmlBodyBuilder::AddDefaultNameSpace(void)
{
	bool bResult1 = SetDefaultNSURL(C2W(TF_DAV_XML_NSURI), C2W(DAV_XML_NAMESPACE_PREFIX));
	bool bResult2 = AppendNamespace(C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	return (bResult1 && bResult2);
}

bool
CTFXmlBodyBuilder::RemoveDefaultNameSpace(void)
{
	bool bResult1 = RemoveNamespace(C2W(TF_DAV_XML_NSURI), C2W(DAV_XML_NAMESPACE_PREFIX));
	bool bResult2 = RemoveNamespace(C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	
	return (bResult1 && bResult2);
}

bool 
CTFXmlBodyBuilder::AddPropUID(const TFXMLCh* pszUID)
{
	bool bResult;
	
	if (IS_EMPTY(pszUID) || TF_STRING_W(pszUID).empty())
		return false;

	XNS(DOMElement)* lpUID = AppendElement(m_lpLast, C2W(TF_PROP_USERID), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetCDATASection(lpUID, pszUID);
	
	return bResult;
}

bool
CTFXmlBodyBuilder:: AddPropName(const TFXMLCh* pszName)
{
	bool bResult;
	
	if (IS_EMPTY(pszName) || TF_STRING_W(pszName).empty())
		return false;

	XNS(DOMElement)* lpUserName = AppendElement(m_lpLast, C2W(TF_PROP_NAME), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetCDATASection(lpUserName, pszName);

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropMailAddr(const TFXMLCh* pszMailAddr)
{
	bool bResult = true;
	XNS(DOMElement)* lpMailAddr = AppendElement(m_lpLast, C2W(TF_PROP_MAILADDR), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (!TF_STRING_W(pszMailAddr).empty())
	{
		bResult = SetCDATASection(lpMailAddr, pszMailAddr);
	}

	return bResult;
}

bool
CTFXmlBodyBuilder:: AddPropComment(const TFXMLCh* pszComment, bool bCDATA)
{
	bool bResult;
	XNS(DOMElement)* lpComment = AppendElement(m_lpLast, C2W(TF_PROP_COMMENT), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (IS_EMPTY(pszComment) || TF_STRING_W(pszComment).empty()) return true;
	if (bCDATA)
		bResult = SetCDATASection(lpComment, pszComment);
	else 
		bResult = SetText(lpComment, pszComment);

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropPassword(const TFXMLCh* pszPassword)
{
	bool bResult;
	if (IS_EMPTY(pszPassword) || TF_STRING_W(pszPassword).empty())
		return false;
		
	XNS(DOMElement)* lpPass = AppendElement(m_lpLast, C2W(TF_PROP_PASSWORD), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetCDATASection(lpPass, pszPassword);
	
	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropAdmin(bool bAdmin)
{
	if (bAdmin)
		XNS(DOMElement)* lpAdmin = AppendElement(m_lpLast, C2W(TF_PROP_ADMIN), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	
	return true;
}

bool
CTFXmlBodyBuilder::AddPropMaxResource(TF_SIZE_T unCount)
{
	bool bResult;

	char chBuf[30];
	sprintf(chBuf, OI_SIZEFORMAT, unCount);
	XNS(DOMElement)* lpMaxResource = AppendElement(m_lpLast, C2W(TF_PROP_MAXRESOURCE),C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetText(lpMaxResource, C2W(chBuf));

	return bResult;
}

bool 
CTFXmlBodyBuilder::AddPropUsedResource(TF_SIZE_T unCount)
{
	bool bResult;

	char chBuf[30];
	sprintf(chBuf, OI_SIZEFORMAT, unCount);
	XNS(DOMElement)* lpMaxResource = AppendElement(m_lpLast, C2W(TF_PROP_USEDRESOURCE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetText(lpMaxResource, C2W(chBuf));

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropMaxStorage(TF_SIZE_T unSize)
{
	bool bResult;
	
	char chBuf[30];
	sprintf(chBuf, OI_SIZEFORMAT, unSize);
	XNS(DOMElement)* lpMaxStorage = AppendElement(m_lpLast, C2W(TF_PROP_MAXSTORAGE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetText(lpMaxStorage, C2W(chBuf));
	
	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropUsedStorage(TF_SIZE_T unSize)
{
	bool bResult;
	
	char chBuf[30];
	sprintf(chBuf, OI_SIZEFORMAT, unSize);
	XNS(DOMElement)* lpMaxStorage = AppendElement(m_lpLast, C2W(TF_PROP_USEDSTORAGE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetText(lpMaxStorage, C2W(chBuf));
	
	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropAccessDeny(const TFXMLCh* pszDeny)
{
	bool bResult;
	if (IS_EMPTY(pszDeny) || TF_STRING_W(pszDeny).empty()) return true;

	XNS(DOMElement)* lpDeny = AppendElement(m_lpLast, C2W(TF_PROP_ACCESSDENY), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetText(lpDeny, pszDeny);

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropUserStatus(TFUSERSTATUS	nStatus)
{

	if (nStatus != TF_USER_STATUS_NONE)
	{
		XNS(DOMElement)* lpStatus = AppendElement(m_lpLast, C2W(TF_PROP_STATE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

		TF_STRING_W strValue;
		for (int i=0; TFUSERSTATUSTABLE[i].pszName != NULL; i++)
		{
			if (nStatus & TFUSERSTATUSTABLE[i].nStatus)
			{
				strValue.erase();
				strValue = C2W(TFUSERSTATUSTABLE[i].pszName);
				XNS(DOMElement)* lpVal = AppendElement(lpStatus, strValue.c_str(), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
				if (!lpVal) return false;
			}
		}
	}

	return true;
}

bool
CTFXmlBodyBuilder::AddPropUserPrivilege(TFUSERPRIV nPriv)
{
	if (nPriv != TF_USER_PRIV_NONE && nPriv != TF_USER_TYPE_UNKNOWN)
	{
		XNS(DOMElement)* lpPriv = AppendElement(m_lpLast, C2W(TF_PROP_USER_PRIVILEGE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
		TF_STRING_W		strValue;
		for (int i=0; TFPRIVILEGETABLE[i].pszName != NULL; i++)
		{
			if (nPriv & TFPRIVILEGETABLE[i].nPriv)
			{
				strValue.erase();
				strValue = C2W(TFPRIVILEGETABLE[i].pszName);
				XNS(DOMElement)* lpVal = AppendElement(lpPriv, strValue.c_str(), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
				if (!lpVal) return false;
			}
		}
	}

	return true;
}

bool
CTFXmlBodyBuilder::AddPropUserType(const TFXMLCh* pszType)
{
	if (IS_EMPTY(pszType) || TF_STRING_W(pszType).empty()) return true;

	XNS(DOMElement)* lpUType = AppendElement(m_lpLast, C2W(TF_PROP_USER_TYPE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	XNS(DOMElement)* lpVal = AppendElement(lpUType, pszType, C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	return (lpVal != NULL);
}

bool
CTFXmlBodyBuilder::AddPropExpiration(time_t time)
{
	bool bResult = true;

	XNS(DOMElement)* lpExpiration = AppendElement(m_lpLast, C2W(TF_PROP_EXPIRATION), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (time > 0)
	{ 
		TF_STRING_A strValue;
		if (!FormatTimeISO8601(strValue, time)) return false;
		
		bResult = SetText(lpExpiration, C2W(strValue.c_str()));
	}

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropMaxusercreation(TF_SIZE_T unCounts)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;
	char chBuf[30];
	sprintf(chBuf, OI_SIZEFORMAT, unCounts);

	XNS(DOMElement)* pMaxuser = AppendElement(m_lpLast, C2W(TF_PROP_MAX_USERCREATION), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pMaxuser) bResult = SetText(pMaxuser, C2W(chBuf));

	return bResult;
}

bool 
CTFXmlBodyBuilder::AddPropCreationDt(time_t time)
{
	bool bResult = true;

	XNS(DOMElement)* lpCreationDt = AppendElement(m_lpLast, C2W(TF_PROP_CREATEDT), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (time > 0)
	{
		OI_STRING_A strValue;
		if (!FormatTimeISO8601(strValue, time)) return false;
		
		bResult = SetText(lpCreationDt, C2W(strValue.c_str()));
	}

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropUpdateDt(time_t time)
{
	bool bResult = true;

	XNS(DOMElement)* lpUpdateDt = AppendElement(m_lpLast, C2W(TF_PROP_UPDATEDT), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (time > 0)
	{
		OI_STRING_A strValue;
		if (!FormatTimeISO8601(strValue, time)) return false;
		
		bResult = SetText(lpUpdateDt, C2W(strValue.c_str()));
	}

	return bResult;
}


bool 
CTFXmlBodyBuilder::AddPropMsgID(const TFXMLCh* pszID)
{
	bool	bResult = false;
	if (IS_EMPTY(pszID)) return false;
	
	XNS(DOMElement)* lpID = AppendElement(m_lpLast, C2W(TF_PROP_MSGID), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetText(lpID, pszID);
	
	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropMsgTxt(const TFXMLCh* pszMsg)
{
	bool	bResult;
	XNS(DOMElement)* lpMsg = AppendElement(m_lpLast, C2W(TF_PROP_MSGTXT), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	bResult = SetCDATASection(lpMsg, pszMsg);
	
	return bResult;
}

bool 
CTFXmlBodyBuilder::AddPropActive(bool bActive)
{
	bool bResult = true;
	if (bActive)
	{
		XNS(DOMElement)* lpActive = AppendElement(m_lpLast, C2W(TF_PROP_USER_STATE_ACTIVE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
		if (!lpActive) bResult = false;
	}
	
	return bResult;
}

bool 
CTFXmlBodyBuilder::AddPropGroupMailWatch(int nMethods)
{
	bool	bResult = false;
	XNS(DOMElement)* lpGrpMW = AppendElement(m_lpLast, C2W(TF_PROP_GROUPMAILWATCH), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	// 特にメソッド定義がない場合は正常終了とする
	if (nMethods == TF_DAV_UNKNOWN) return true;

	if (lpGrpMW)
	{
		TF_STRING_W	strMethods;
		BuildMailWatch(nMethods, strMethods); 
		if (!strMethods.empty())
		{
			XNS(DOMElement)* lpTrgMethod = AppendElement(lpGrpMW,  C2W(TF_PROP_TRIGGERMETHOD), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
			if (lpTrgMethod)
			{
				bResult = SetText(lpTrgMethod, strMethods.c_str());
			}
		}
		else
		{
			return true;	// ここにくる事はない
		}
	}
	
	return bResult;
}

bool 
CTFXmlBodyBuilder::AddPropGroupID(const TFXMLCh* pszID)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	if (IS_EMPTY(pszID)) return true;

	XNS(DOMElement)* pGrpID = AppendElement(m_lpLast, C2W(TF_PROP_GROUPID), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pGrpID)
		bResult = SetCDATASection(pGrpID, pszID);

	return bResult;
}

bool 
CTFXmlBodyBuilder::AddPropGroupUri(const TFXMLCh* pszuri)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	if (IS_EMPTY(pszuri)) return true;

	XNS(DOMElement)* pGrpURI = AppendElement(m_lpLast, C2W(TF_PROP_GROUPURI), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pGrpURI)
		bResult = SetCDATASection(pGrpURI, pszuri);

	return bResult;

}

bool 
CTFXmlBodyBuilder::AddPropGroupState(int nState)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	XNS(DOMElement)* pState = AppendElement(m_lpLast, C2W(TF_PROP_GROUPSTATE), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pState)
	{
		if (nState != TF_GROUPSTATE_NONE)
		{
			for (int i=0; TF_GROUPSTATE_TABLE[i].dwGroupState != TF_GROUPSTATE_NONE; i++)
			{
				if (TF_GROUPSTATE_TABLE[i].dwGroupState & nState)
					XNS(DOMElement)* pData = AppendElement(pState, C2W(TF_GROUPSTATE_TABLE[i].pszTagName), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
			}
		}

		bResult = true;
	}

	return bResult;

}

bool CTFXmlBodyBuilder::AddPropGroupConstraints(int nConstraints)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;
	XNS(DOMElement)* pConst = AppendElement(m_lpLast, C2W(TF_PROP_CONSTRAINTS), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pConst)
	{
		if (nConstraints != TF_GROUPCONSTRAINTS_NONE)
		{
			for (int i=0; TF_GROUP_CONSTRAINTS_TABLE[i].dwConstraints != TF_GROUPCONSTRAINTS_NONE; i++)
			{
				if (TF_GROUP_CONSTRAINTS_TABLE[i].dwConstraints & nConstraints)
					XNS(DOMElement)* pData = AppendElement(pConst, C2W(TF_GROUP_CONSTRAINTS_TABLE[i].szTagName), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

			}
		}

		bResult = true;
	}

	return bResult;

}

bool 
CTFXmlBodyBuilder::AddPropChangeLeader(const TFXMLCh* userid, TFCHANGELEADERTYPE nType)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;
	bool bResultID = false;

	XNS(DOMElement)* pChgLeader = AppendElement(m_lpLast, C2W(TF_PROP_CHANGELEADER), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pChgLeader)
	{
		XNS(DOMElement)* pOwnerID = AppendElement(pChgLeader, C2W(TF_PROP_OWNER_ID),
													C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
		// オーナーID
		if (pOwnerID)
			bResultID = SetCDATASection(pOwnerID, userid);

		//　アクション
		XNS(DOMElement)* pAction = AppendElement(pChgLeader, C2W(TF_PROP_ACTION),
													C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
		if (pAction)
		{

			XNS(DOMElement)* pEleAction = AppendElement(pAction, 
														nType == TF_CHG_LEADER_APPOINTED 
														? C2W(TF_PROP_CHANGELEADERAPPOINT) 
														: C2W(TF_PROP_CHANGELEADERDISMISS),
														C2W(TF_XML_NSURI),
														C2W(TF_XML_NAMESPACE_PREFIX)); 
		}

		bResult = true;
	}

	return (bResult && bResultID);
}

bool CTFXmlBodyBuilder::AddPropOwnerName(const TFXMLCh* pszName)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	XNS(DOMElement)* pOwnerName = AppendElement(m_lpLast, C2W(TF_PROP_OWNER_NAME),
													C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (TF_STRING_W(pszName).empty()) return true;

	if (pOwnerName)
		bResult = SetCDATASection(pOwnerName, pszName);

	return bResult;
}

bool CTFXmlBodyBuilder::AddPropOwnerID(const TFXMLCh* pszID)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	XNS(DOMElement)* pOwnerID = AppendElement(m_lpLast, C2W(TF_PROP_OWNER_ID),
													C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (TF_STRING_W(pszID).empty()) return true;

	if (pOwnerID)
		bResult = SetCDATASection(pOwnerID, pszID);

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropLastAccessClient(const TFXMLCh* pszClient)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	XNS(DOMElement)* pLastAccessClient = AppendElement(m_lpLast, C2W(TF_PROP_LASTACCESSCLIENT),
													C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (TF_STRING_W(pszClient).empty()) return true;
	
	if (pLastAccessClient)
		bResult = SetCDATASection(pLastAccessClient, pszClient);
		
	return bResult;
}


bool
CTFXmlBodyBuilder::AddPropLastAccessDt(time_t time)
{
	OI_ASSERT(m_lpLast);
	bool bResult = false;

	XNS(DOMElement)* pLastAccessDt = AppendElement(m_lpLast, C2W(TF_PROP_LASTACCESSDT),
												   C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (time > 0)
	{ 
		OI_STRING_A strValue;
		if (!FormatTimeISO8601(strValue, time)) return false;
		
		bResult = SetText(pLastAccessDt, C2W(strValue.c_str()));
	}

	return bResult;
}

bool
CTFXmlBodyBuilder::AddPropLineup(const TFXMLCh* pszLineup)
{
	OI_ASSERT(m_lpLast);
	OI_ASSERT(pszLineup);
	
	bool	bResult = false;
	
	XNS(DOMElement)* pLineup = AppendElement(m_lpLast, C2W(TF_PROP_LINEUP), 
													C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	if (pLineup)
		bResult = SetText(pLineup, pszLineup);
	
	return bResult;
	
}

XNS(DOMElement)* 
CTFXmlBodyBuilder::AddPropFamily(const TFXMLCh* pszElementName,
								 const TFXMLCh* pszNSURI,
								 const TFXMLCh* pszNSPrefix)
{
	if (IS_EMPTY(pszElementName)) return NULL;

	XNS(DOMElement)* pParent = NULL;
	if (m_lpLast)
		pParent = m_lpLast;
	else
		pParent = GetRootElement();

	XNS(DOMElement)* pFamily = AppendElement(pParent, pszElementName, 
											 C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (pFamily) m_lpLast = pFamily;
	return pFamily;
}

XNS(DOMElement)*
CTFXmlBodyBuilder::AddPropChild(XNS(DOMElement)* pParent,
								const TFXMLCh* pszElementName,
								const TFXMLCh* pszNSURI,
								const TFXMLCh* pszNSPrefix)
{
	if (pParent == NULL) return NULL;
	if (IS_EMPTY(pszElementName)) return NULL;

	XNS(DOMElement)* pChild = AppendElement(pParent, pszElementName, 
											C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	return pChild;
	
}

bool 
CTFXmlBodyBuilder::AddPropNodeValue(XNS(DOMElement)*	pNode,
									const TFXMLCh*		pszValue,
									bool				bCDATA)
{
	if (pNode == NULL) return false;
	if (IS_EMPTY(pszValue)) return false;

	bool bResult = false;

	if (bCDATA)
		bResult = SetCDATASection(pNode, pszValue);
	else
		bResult = SetText(pNode, pszValue);

	return bResult;
}


bool
CTFXmlBodyBuilder::AddPropOtheruser(bool bIsOther)
{
	OI_ASSERT(m_lpLast);
	bool	bResult = false;

	if (bIsOther)
	{
		XNS(DOMElement)* pOther = AppendElement(m_lpLast, C2W(TF_PROP_OTHERUSER), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
		bResult = (pOther!=NULL);
	}

	return bResult;

}
