#include "TFXmlBodyMKCOL.h"

CTFXmlBodyMKCOL::CTFXmlBodyMKCOL(void)
{
}

CTFXmlBodyMKCOL::~CTFXmlBodyMKCOL(void)
{
}

bool 
CTFXmlBodyMKCOL::CreateBodyUser(CTFResourcePropTFUser& cUserItem)
{
	CTFXmlBodyBuilder	cXMLBuilder;

	try {
		cXMLBuilder.Initialize(C2W("propertyupdate"));
		cXMLBuilder.AddDefaultNameSpace();
		cXMLBuilder.AddPropSet();
		cXMLBuilder.AddPropDiscovery(TF_PROP_DISCOVERY_USER);

		cXMLBuilder.AddPropUID(cUserItem.GetUID());
		cXMLBuilder.AddPropName(cUserItem.GetName());
		cXMLBuilder.AddPropMailAddr(cUserItem.GetMailAddr());
		cXMLBuilder.AddPropComment(cUserItem.GetComment());
		cXMLBuilder.AddPropPassword(cUserItem.GetPassWord());
		cXMLBuilder.AddPropAdmin(cUserItem.GetAdminFlag());
		cXMLBuilder.AddPropMaxStorage(cUserItem.GetStorages(TF_STAT_MAX));
		cXMLBuilder.AddPropMaxResource(cUserItem.GetResources(TF_STAT_MAX));
		cXMLBuilder.AddPropAccessDeny(cUserItem.GetAccessDeny());
		cXMLBuilder.AddPropUserStatus(cUserItem.GetStatus());
		cXMLBuilder.AddPropUserPrivilege(cUserItem.GetPrivilege());
		cXMLBuilder.AddPropUserType(X(cUserItem.GetUserTypeString()));
		cXMLBuilder.AddPropExpiration(cUserItem.GetExpiration());
		cXMLBuilder.AddPropMaxusercreation(cUserItem.GetMaxuserCreation());
	} catch (...) {
		return false;
	}

	return ImportDocument(cXMLBuilder, m_xbfBody.GetDocument());
}

bool 
CTFXmlBodyMKCOL::CreateBodyGroup(CTFResourcePropTFGroup& cGrpItem)
{
	CTFXmlBodyBuilder	cXMLBuilder;
	
	try {
		cXMLBuilder.Initialize(C2W("propertyupdate"));
		cXMLBuilder.AddDefaultNameSpace();
		cXMLBuilder.AddPropSet();
		cXMLBuilder.AddPropDiscovery(TF_PROP_DISCOVERY_GROUP);

		cXMLBuilder.AddPropName(cGrpItem.GetName());
		cXMLBuilder.AddPropComment(cGrpItem.GetComment());
		cXMLBuilder.AddPropGroupMailWatch(cGrpItem.GetGrpMailWatch());
		cXMLBuilder.AddPropGroupState(cGrpItem.GetGroupState());
		cXMLBuilder.AddPropGroupConstraints(cGrpItem.GetGroupConstraints());
	} catch (...) {
		return false;
	}
	
	return ImportDocument(cXMLBuilder, m_xbfBody.GetDocument());
}

bool
CTFXmlBodyMKCOL::CreateBodyMessage(CTFResourcePropTFMsg& cMsgItem)
{
	CTFXmlBodyBuilder	cXMLBuilder;

	try {
		cXMLBuilder.Initialize(C2W("propertyupdate"));
		cXMLBuilder.AddDefaultNameSpace();
		cXMLBuilder.AddPropSet();
		cXMLBuilder.AddPropDiscovery(TF_PROP_DISCOVERY_SYSMSG);
		
		cXMLBuilder.AddPropMsgID(cMsgItem.GetID());
		cXMLBuilder.AddPropMsgTxt(cMsgItem.GetMsg());
		cXMLBuilder.AddPropActive(cMsgItem.GetActiveFlag());
	} catch (...) {
		return false;
	}
	
	return ImportDocument(cXMLBuilder, m_xbfBody.GetDocument());
}


