#include "TFXmlBodyPropPatch.h"

CTFXmlBodyPropPatch::CTFXmlBodyPropPatch(void)
{
}

CTFXmlBodyPropPatch::~CTFXmlBodyPropPatch(void)
{
}

bool
CTFXmlBodyPropPatch::CreateBodyUser(CTFResourcePropTFUser &pUserItem)
{
	CTFXmlBodyBuilder	cXMLBuilder;

	try {
		cXMLBuilder.Initialize(C2W("propertyupdate"));
		cXMLBuilder.AddDefaultNameSpace();
		cXMLBuilder.AddPropSet();
		cXMLBuilder.AddPropDiscovery(TF_PROP_DISCOVERY_USER);

		cXMLBuilder.AddPropName(pUserItem.GetName());
		cXMLBuilder.AddPropMailAddr(pUserItem.GetMailAddr());
		cXMLBuilder.AddPropComment(pUserItem.GetComment());
		cXMLBuilder.AddPropPassword(pUserItem.GetPassWord());
		cXMLBuilder.AddPropAdmin(pUserItem.GetAdminFlag());
		cXMLBuilder.AddPropMaxStorage(pUserItem.GetStorages(TF_STAT_MAX));
		cXMLBuilder.AddPropMaxResource(pUserItem.GetResources(TF_STAT_MAX));
		cXMLBuilder.AddPropAccessDeny(pUserItem.GetAccessDeny());
		cXMLBuilder.AddPropUserStatus(pUserItem.GetStatus());
		cXMLBuilder.AddPropUserPrivilege(pUserItem.GetPrivilege());
		cXMLBuilder.AddPropUserType(X(pUserItem.GetUserTypeString()));
		cXMLBuilder.AddPropExpiration(pUserItem.GetExpiration());
		cXMLBuilder.AddPropMaxusercreation(pUserItem.GetMaxuserCreation());
	} catch (...) {
		return false;
	}

	return ImportDocument(cXMLBuilder, m_xbfBody.GetDocument());
}

bool
CTFXmlBodyPropPatch::CreateBodyGroup(CTFResourcePropTFGroup &pGroupItem)
{
	CTFXmlBodyBuilder	cXMLBuilder;

	try {
		cXMLBuilder.Initialize(C2W("propertyupdate"));
		cXMLBuilder.AddDefaultNameSpace();
		cXMLBuilder.AddPropSet();
		cXMLBuilder.AddPropDiscovery(TF_PROP_DISCOVERY_GROUP);

		cXMLBuilder.AddPropComment(pGroupItem.GetComment());
		cXMLBuilder.AddPropGroupMailWatch(pGroupItem.GetGrpMailWatch());
		cXMLBuilder.AddPropGroupState(pGroupItem.GetGroupState());
		cXMLBuilder.AddPropGroupConstraints(pGroupItem.GetGroupConstraints());

	} catch (...) {
		return false;
	}

	return ImportDocument(cXMLBuilder, m_xbfBody.GetDocument());
}

bool 
CTFXmlBodyPropPatch::CreateBodyChangeLeader(CTFResourcePropTFGroup &pGroupItem, TFCHANGELEADERTYPE nType)
{
	CTFXmlBodyBuilder	cXMLBuilder;

	try {
		cXMLBuilder.Initialize(C2W("propertyupdate"));
		cXMLBuilder.AddDefaultNameSpace();
		cXMLBuilder.AddPropSet();

		cXMLBuilder.AddPropChangeLeader(pGroupItem.GetGroupOwnerID(), nType);
	} catch (...) {
		return false;
	}

	return ImportDocument(cXMLBuilder, m_xbfBody.GetDocument());

}
