#include "TFXmlBodySearch.h"

CTFXmlBodySearch::CTFXmlBodySearch(void)
{
}

CTFXmlBodySearch::~CTFXmlBodySearch(void)
{
}

bool
CTFXmlBodySearch::CreateBodyRootTree(TF_SEARCH_MODE enuMode)
{
	CTFXmlBodyBuilder	cXmlBuilder;
	
	try {

		cXmlBuilder.Initialize(C2W("searchrequest"));
		cXmlBuilder.AddDefaultNameSpace();
		cXmlBuilder.AddPropSearch(TF_DASL_ROOTTREE);
		cXmlBuilder.AddPropSearchMode(enuMode);

	} catch (...) {
		return false;
	}

	return ImportDocument(cXmlBuilder, m_xbfBody.GetDocument());
}

bool 
CTFXmlBodySearch::CreateBodyUser(TF_SEARCH_MODE enuMode, const TFXMLCh* pszUID)
{
	CTFXmlBodyBuilder	cXmlBuilder;
	
	try {

		cXmlBuilder.Initialize(C2W("searchrequest"));
		cXmlBuilder.AddDefaultNameSpace();
		cXmlBuilder.AddPropSearch(TF_DASL_USERINFORMATION);
		if (IS_FILLED(pszUID)) cXmlBuilder.AddPropUID(pszUID);
		cXmlBuilder.AddPropSearchMode(enuMode);

	} catch(...) {
		return false;
	}
	
	return ImportDocument(cXmlBuilder, m_xbfBody.GetDocument());
}

bool
CTFXmlBodySearch::CreateBodyStatus(TF_SEARCH_MODE enuMode)
{

	CTFXmlBodyBuilder	cXmlBuilder;

	try {

		cXmlBuilder.Initialize(C2W("searchrequest"));
		cXmlBuilder.AddDefaultNameSpace();
		cXmlBuilder.AddPropSearch(TF_DASL_STATUSINFORMATION);
		cXmlBuilder.AddPropSearchMode(enuMode);

	} catch(...) {
		return false;
	}

	return ImportDocument(cXmlBuilder, m_xbfBody.GetDocument());
}

bool 
CTFXmlBodySearch::CreateBodyGroup(TF_SEARCH_MODE enuMode, CTFResourcePropTFGroup* pGrpItem)
{
	CTFXmlBodyBuilder	cXmlBuilder;

	try {
		cXmlBuilder.Initialize(C2W("searchrequest"));
		cXmlBuilder.AddDefaultNameSpace();
		cXmlBuilder.AddPropSearch(TF_DASL_GROUPINFORMATION);
		cXmlBuilder.AddPropSearchMode(enuMode);

		// content availableuser availablesqlの時はグループアイテムは必須
		if (enuMode == TF_SEARCH_MODE_CONTENT ||
			enuMode == TF_SEARCH_MODE_AVAILABLEUSER ||
			enuMode == TF_SEARCH_MODE_AVAILABLESQL || 
			enuMode == TF_SEARCH_MODE_DETAILLIST)
		{
			if (pGrpItem == NULL) return false;

			if (!TF_STRING_W(pGrpItem->GetID()).empty())
			{
				cXmlBuilder.AddPropGroupID(pGrpItem->GetID());
			}
			else if (!TF_STRING_W(pGrpItem->GetName()).empty())
			{
				cXmlBuilder.AddPropGroupUri(pGrpItem->GetName());
			}
			else
			{
				if (enuMode != TF_SEARCH_MODE_DETAILLIST)
					return false;
			}
		}
		else
		{
			if (pGrpItem != NULL) 
			{
				if (!TF_STRING_W(pGrpItem->GetID()).empty())
				{
					cXmlBuilder.AddPropGroupID(pGrpItem->GetID());
				}
			}
		}

	} catch(...) {
		return false;
	}

	return ImportDocument(cXmlBuilder, m_xbfBody.GetDocument());

}

bool 
CTFXmlBodySearch::CreateBodySysMsg(TF_SEARCH_MODE enuMode, const TFXMLCh* pszMsgID)
{
	CTFXmlBodyBuilder	cXmlBuilder;

	try {
		cXmlBuilder.Initialize(C2W("searchrequest"));
		cXmlBuilder.AddDefaultNameSpace();
		cXmlBuilder.AddPropSearch(TF_DASL_SYSMSGINFORMATION);
		cXmlBuilder.AddPropSearchMode(enuMode);

		if (enuMode == TF_SEARCH_MODE_CONTENT && IS_FILLED(pszMsgID))
		{
			cXmlBuilder.AddPropMsgID(pszMsgID);
		}
		
	} catch (...) {
		return false;
	}

	return ImportDocument(cXmlBuilder, m_xbfBody.GetDocument());
}

bool
CTFXmlBodySearch::CreateBodyUpdate(TF_SEARCH_MODE enuMode, const TFXMLCh* pszLineup)
{
	CTFXmlBodyBuilder	cXmlBuilder;

	try {
		cXmlBuilder.Initialize(C2W("searchrequest"));
		cXmlBuilder.AddDefaultNameSpace();
		cXmlBuilder.AddPropSearch(TF_DASL_UPDATEINFORMATION);
		cXmlBuilder.AddPropSearchMode(enuMode);
		
		if (enuMode == TF_SEARCH_MODE_CONTENT && IS_FILLED(pszLineup))
		{
			cXmlBuilder.AddPropLineup(pszLineup);
		}
		
	} catch(...) {
		return false;
	}

	return ImportDocument(cXmlBuilder, m_xbfBody.GetDocument());
}
