/* 
   Authentication manager
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavAuthManager.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/DavAuthManager.h>
#include <onion/DavAuthSession.h>
#include <onion/DavWorkSession.h>

CDavAuthManager::CDavAuthManager(CDavWorkSession* pWorkSession)
{
  OI_ASSERT(pWorkSession);

  m_pWorkSession = pWorkSession;
  m_pServerAuthSession	= new CDavAuthSession(this, OI_REQHDR_AUTH,
					      OI_RSPHDR_AUTH,
					      OI_RSPHDR_AUTHINFO,
					      401,
					      C_AUTH_SERVER);
  m_pProxyAuthSession = new CDavAuthSession(this, OI_REQHDR_PROXYAUTH,
					    OI_RSPHDR_PROXYAUTH,
					    OI_RSPHDR_PROXYAUTHINFO,
					    407,
					    C_AUTH_PROXY);
  Reset();
}

CDavAuthManager::~CDavAuthManager(void)
{
  delete m_pServerAuthSession;
  delete m_pProxyAuthSession;
}

void
CDavAuthManager::Reset()
{
  m_pServerAuthSession->Reset();
  m_pProxyAuthSession->Reset();
}

void
CDavAuthManager::ResetServer()
{
  m_pServerAuthSession->Reset();
}

void
CDavAuthManager::ResetProxy()
{
  m_pProxyAuthSession->Reset();
}

const char*
CDavAuthManager::GetUsername()
{
  return m_pServerAuthSession->GetUsername();
}

const char*
CDavAuthManager::GetPasswd()
{
  return m_pServerAuthSession->GetPasswd();
}

const char*
CDavAuthManager::GetProxyUsername()
{
  return m_pProxyAuthSession->GetUsername();
}

const char*
CDavAuthManager::GetProxyPasswd()
{
  return m_pProxyAuthSession->GetPasswd();
}

bool
CDavAuthManager::OnAuthentication(X& strRealm,
				  OI_STRING_A& strUsername, 
				  OI_STRING_A& strPasswd,
				  int nRetry,
				  OI_AUTH_CLASS enuAuthClass)
{
  return m_pWorkSession->OnAuthentication(strRealm,
					  strUsername,
					  strPasswd,
					  nRetry,
					  enuAuthClass);
}

OI_RESULT
CDavAuthManager::OnCreateRequest(CDavRequest* pReq)
{
  m_pProxyAuthSession->OnCreateRequest(pReq);
  m_pServerAuthSession->OnCreateRequest(pReq);
  return OI_OK;
}

OI_RESULT
CDavAuthManager::OnPreSendRequest(CDavRequest* pReq)
{
  m_pProxyAuthSession->OnPreSendRequest(pReq);
  m_pServerAuthSession->OnPreSendRequest(pReq);
  return OI_OK;
}

OI_RESULT
CDavAuthManager::QueryEndRequest(CDavRequest* pReq)
{
  OI_RESULT enuRet;

  enuRet = m_pProxyAuthSession->QueryEndRequest(pReq);
  if(OI_RETRY == enuRet) 
    return enuRet;
  enuRet = m_pServerAuthSession->QueryEndRequest(pReq);
  return enuRet;
}



