/* 
   Authentication manager
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavAuthManager.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVAUTHMANAGER_H
#define ONION_HEADER_DAVAUTHMANAGER_H 1

#include <onion/OnionCfg.h>

//forward declarations
class CDavAuthSession;
class CDavWorkSession;
class CDavRequest;

/** <code>CDavAuthManager</code> relays username and password between
 * <code>CDavAuthSession</code> and <code>CDavWorkSession</code>.
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavAuthManager
{
 public:
  CDavAuthManager(CDavWorkSession* pWorkSession);
  virtual ~CDavAuthManager(void);

  virtual bool OnAuthentication(X& strRealm,
				OI_STRING_A& strUsername,
				OI_STRING_A& strPasswd,
				int nRetry,
				OI_AUTH_CLASS enuAuthClass);

  void Reset();
  void ResetServer();
  void ResetProxy();

  const char* GetUsername();
  const char* GetPasswd();
  const char* GetProxyUsername();
  const char* GetProxyPasswd();

  virtual OI_RESULT OnCreateRequest(CDavRequest* pReq);
  virtual OI_RESULT OnPreSendRequest(CDavRequest* pReq);
  virtual OI_RESULT QueryEndRequest(CDavRequest* pReq);


 private:
  CDavAuthSession* m_pServerAuthSession;
  CDavAuthSession* m_pProxyAuthSession;
  CDavWorkSession* m_pWorkSession;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVAUTHMANAGER_H*/
