/* 
   Host infomation wrapper
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavHost.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/DavHost.h>

CDavHost::CDavHost()
{
  m_usPort = 0;
}

CDavHost::CDavHost(const char *pszName, unsigned short usPort)
{
  OI_ASSERT(pszName);
  m_strHostName = pszName;
  m_usPort = usPort;
}

CDavHost::CDavHost(const CDavHost& old)
{
  copy(old);
}

CDavHost::~CDavHost(void)
{
}

const char*		
CDavHost::GetHostName()	
{
  return m_strHostName.c_str();
}

unsigned short
CDavHost::GetPort()
{
  return m_usPort;
}

void 
CDavHost::SetHostName(const char *pszName)
{
  OI_ASSERT(pszName);
  m_strHostName = pszName;
}

void 
CDavHost::SetPort(unsigned short usPort)
{
  m_usPort = usPort;
}

void 
CDavHost::copy(const CDavHost& old)
{
  m_strHostName = old.m_strHostName;
  m_usPort = old.m_usPort;
}

CDavHost& 
CDavHost::operator =(const CDavHost& old)
{
  copy(old);
  return *this;
}

