/* 
   Http status line infomation container
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavHttpStatus.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <ctype.h>
#include <string.h>
#include <onion/DavHttpStatus.h>

CDavHttpStatus::CDavHttpStatus()
{
  Clear();
}

CDavHttpStatus::~CDavHttpStatus()
{
}

void
CDavHttpStatus::Clear()
{
  m_nCode = 0;
  m_nCodeClass = 0;
  m_nMajorVersion = 0;
  m_nMinorVersion = 0;
  m_strReason.erase();
}

OI_RESULT 
CDavHttpStatus::Parse(const char* pszBuf)
{
  OI_ASSERT(pszBuf);

  int nMajor, nMinor;
  char* pszPart;
  pszBuf = strstr(pszBuf, "HTTP/");
  if(0 == pszBuf)
    //server is not talking back in HTTP protocol
    return OIHEPROTOCOLPANIC;

  //check nMajor and nMinor version of HTTP protocol
  nMajor = 0;
  nMinor = 0;

  //extract nMajor version number
  for(pszPart = (char*)(pszBuf + 5); 
      *pszPart != '\0' && isdigit(*pszPart);
      pszPart++){
    nMajor = nMajor*10 + (*pszPart - '0');
  }
	
  //now the pszPart pointer should stop exactly at '.' 
  if(*pszPart != '.')
    return OIHEPROTOCOLPANIC;

  //extract monir version number
  for(pszPart++; 
      *pszPart != '\0' && isdigit(*pszPart);
      pszPart++){
    nMinor = nMinor*10 + (*pszPart - '0');
  }
	
  //now the pszPart pointer should stop exactly at ' ' 
  if(*pszPart != ' ')
    return OIHEPROTOCOLPANIC;

  //skip any spaces
  for(; *pszPart == ' '; pszPart++);

  //now the pointer should be pointing exactly at the status code
  if(strlen(pszPart) < 4)
    return OIHEPROTOCOLPANIC;

  if( !isdigit(pszPart[0]) ||
      !isdigit(pszPart[1]) ||
      !isdigit(pszPart[2]) ||
      (pszPart[3] != '\0' && pszPart[3] != ' ')){
    return OIHEPROTOCOLPANIC;
  }

  m_nCode = 100*(pszPart[0]-'0') + 10*(pszPart[1]-'0') + (pszPart[2]-'0');
  m_nCodeClass = pszPart[0]-'0';
  m_nMajorVersion = nMajor;
  m_nMinorVersion = nMinor;

  //skip white spaces before reason phrases
  for (pszPart+=3; *pszPart == ' ' || *pszPart == '\t'; pszPart++);

  m_strReason = pszPart;
  return OI_OK;
}

