/* 
   Http stream
   Copyright (C) 2003-2005, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavHttpStream.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVHTTPSTREAM_H
#define ONION_HEADER_DAVHTTPSTREAM_H 1

#include <onion/OnionCfg.h>
#include <onion/DavRequest.h>

//forward declaration
class CDavWorkSession;
class CDavResponseBody;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavHttpStream : protected CDavRequest
{
  friend class CDavWorkSession;
 public:
  virtual OI_RESULT Read(void* pvData,
			 size_t unBufLen,
			 size_t* punReadLen);
  virtual OI_RESULT Write(void* pvData,
			  size_t unBufLen,
			  size_t* punWrittenLen);
 protected:
  CDavHttpStream();
  virtual ~CDavHttpStream();
  OI_RESULT createStream(CDavWorkSession* pSession,
			 const X& strURI,
			 OI_STREAM_MODE enuMode);
 protected:
  CDavResponseBody* m_pBody;
  OI_STREAM_MODE m_enuMode;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVHTTPSTREAM_H*/
