/* 
   Lock infomation container
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavLock.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVLOCK_H
#define ONION_HEADER_DAVLOCK_H 1

#include <onion/OnionCfg.h>
#include <xercesc/dom/DOM.hpp>

/** <code>CDavLock</code> holds information for each
 * lock. <code>CDavResourceNode</code> constructs a 
 * list of <code>CDavLock</code> for each DAV resource.
 * <code>CDavWorkSession</code> uses this class as 
 * input of <code>CDavWorkSession::DoLock()</code> 
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavLock
{
 public:
  CDavLock();
  ~CDavLock();
  CDavLock& operator=(const CDavLock& master);
 public:
  unsigned int m_unMask;
  OI_LOCK_TYPE m_enuType;
  OI_LOCK_SCOPE m_enuScope;
  OI_LOCK_DEPTH	m_enuDepth;
  long m_lTimeout;		//0 means infinite
  OI_STRING_A m_strToken;
  XNS(DOMNode)*	m_pOwner;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVLOCK_H*/
