/* 
   Dav resource infomation container
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavResourceNode.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVRESOURCENODE_H
#define ONION_HEADER_DAVRESOURCENODE_H 1

#include <onion/OnionCfg.h>
#include <onion/DavLock.h>
#include <xercesc/dom/DOM.hpp>
#include <map>
#include <vector>
/** This is the interface to get DAV resource infomation from.
 *  Each time a "response" element is received, 
 *  CDavWorkSession::OnResponseFound() will be called and the
 *  resource node will be passed.
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavResourceNode
{
 private:
  typedef std::vector<CDavLock> LOCKLIST;
  typedef std::map<int, XNS(DOMNode)*> PROPSTATMAP;
 public:
  CDavResourceNode();
  ~CDavResourceNode();
  OI_RESULT Parse(XNS(DOMNode)* pResponse,
		  unsigned long ulPropsToParse = OI_RNP_CONVENTIONAL);
  void Reset();
  X& URI();
  X& DisplayName();
  OI_RES_TYPE GetResourceType();
  OI_SIZE_T GetContentLength();
  time_t GetLastModified();
  time_t GetCreationDate();
  const char* GetETag();
  const char* GetContentType();
  const char* GetContentLanguage();
  OI_SIZE_T GetQuota();
  OI_SIZE_T GetQuotaUsed();
  unsigned long GetFlags();
  XNS(DOMNode)* GetProp(int nStatusCode);
  int GetLockCount();
  CDavLock* GetLock(unsigned int unIndex);
  static bool parseLockStatic(XNS(DOMNode)* pNode, CDavLock* pLock);
 private:
  int getStatusCode(XNS(DOMNode)* pStatus);
  void parseProp(XNS(DOMNode)* pProp);
  void parseResourceType(XNS(DOMNode)* pProp);
  void parseContentLength(XNS(DOMNode)* pProp);
  void parseDisplayName(XNS(DOMNode)* pProp);
  void parseLastModified(XNS(DOMNode)* pProp);
  void parseCreationDate(XNS(DOMNode)* pProp);
  void parseETag(XNS(DOMNode)* pProp);
  void parseContentType(XNS(DOMNode)* pProp);
  void parseContentLanguage(XNS(DOMNode)* pProp);
  void parseSupportedLock(XNS(DOMNode)* pProp);
  void parseActiveLock(XNS(DOMNode)* pProp);
  void parseQuota(XNS(DOMNode)* pProp);
  void parseQuotaUsed(XNS(DOMNode)* pProp);
  void removeUnprocessed(XNS(DOMNode)* pProp, int nStatus);
 private:
  unsigned long	m_ulPropsToParse;
  unsigned long	m_ulValidProps;

  OI_RES_TYPE m_enuResourceType;
  OI_SIZE_T m_unContentLength;

  OI_STRING_A m_strContentLanguage;
  OI_STRING_A m_strContentType;
  OI_STRING_A m_strETag;
  X m_strDisplayName;
  X m_strURI;

  time_t m_tmCreationDate;
  time_t m_tmLastModified;

  OI_SIZE_T m_unQuota;
  OI_SIZE_T m_unQuotaUsed;

  PROPSTATMAP m_mapPropStats;
  LOCKLIST m_vecLocklist;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVRESOURCENODE_H*/
