/* 
   SSL certificate export data container
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavSSLCertificateData.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/DavSSLCertificateData.h>

CDavSSLCertificateData::CDavSSLCertificateData()
{
  m_pBIO = NULL;
}

CDavSSLCertificateData::~CDavSSLCertificateData()
{
  if(m_pBIO)
    BIO_free(m_pBIO);
}

void
CDavSSLCertificateData::Clear()
{
  if(m_pBIO) {
    BIO_free(m_pBIO);
    m_pBIO = NULL;
  }
  m_pBIO = BIO_new(BIO_s_mem());
}

BIO*
CDavSSLCertificateData::GetBIO()
{
  return m_pBIO;
}

void*
CDavSSLCertificateData::GetData()
{
  if(!m_pBIO)
    return NULL;
  BUF_MEM* pBuf = NULL;
  BIO_get_mem_ptr(m_pBIO, &pBuf);
  if(!pBuf)
    return NULL;
  return pBuf->data;
}

unsigned int
CDavSSLCertificateData::GetDataLength()
{
  if(!m_pBIO)
    return 0;
  BUF_MEM* pBuf = NULL;
  BIO_get_mem_ptr(m_pBIO, &pBuf);
  if(!pBuf)
    return 0;
  return pBuf->length;
}
