/* 
   List of SSL certificates
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavSSLCertificateList.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVSSLCERTIFICATELIST_H
#define ONION_HEADER_DAVSSLCERTIFICATELIST_H 1

#include <onion/OnionCfg.h>
#include <onion/DavSSLCertificate.h>
#include <openssl/ssl.h>
#include <vector>

class CDavSSLCertificate;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavSSLCertificateList
{
 private:
  typedef std::vector<CDavSSLCertificate> SSLCERTLIST;
 public:
  CDavSSLCertificateList();
  ~CDavSSLCertificateList();
  unsigned int GetCount();
  int Load(BIO* pBIO,
	   OI_SSL_CRTMSG enuMsgFormat,
	   OI_SSL_CRTENC enuEncFormat);
  int Load(const char* pszPath,
	   OI_SSL_CRTMSG enuMsgFormat,
	   OI_SSL_CRTENC enuEncFormat);
  int Load(void* pvData,
	   unsigned int unLen,
	   OI_SSL_CRTMSG enuMsgFormat,
	   OI_SSL_CRTENC enuEncFormat);
  bool Save(const char* pszPath,
	    OI_SSL_CRTENC enuEncFormat);
  void Clear();
  void AddCertificate(const CDavSSLCertificate& cert);
  CDavSSLCertificate& operator[](unsigned int unIndex);
 private:
  SSLCERTLIST m_vecCertificateList; 
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVSSLCERTIFICATELIST_H*/
