/* 
   Field of distinguish name
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavSSLDNameField.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/DavSSLDNameField.h>


CDavSSLDNameField::CDavSSLDNameField()
{
}

CDavSSLDNameField::~CDavSSLDNameField()
{
}

void 
CDavSSLDNameField::AddValue(const char* pszValue)
{
  if(pszValue)
    m_vecValues.push_back(pszValue);
}

void 
CDavSSLDNameField::Clear()
{
  m_vecValues.clear();
}

unsigned int 
CDavSSLDNameField::GetCount()
{
  return m_vecValues.size();
}

const char* 
CDavSSLDNameField::GetValue(unsigned int unIndex)
{
  if(unIndex < m_vecValues.size())
    return m_vecValues[unIndex].c_str();
  else
    return NULL;
}

const char* 
CDavSSLDNameField::operator [](unsigned int unIndex)
{
  return GetValue(unIndex);
}

CDavSSLDNameField& 
CDavSSLDNameField::operator=(const CDavSSLDNameField& master)
{
  m_vecValues = master.m_vecValues;
  return *this;
}

