/* 
   Raw socket I/O methods
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>
   Copyright (C) 1998-2004, Joe Orton <joe@manyfish.co.uk>,
   Copyright (C) 1999-2000, Tommi Komulainen <Tommi.Komulainen@iki.fi>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavSocketIORaw.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if defined(HAVE_SYS_TYPES_H) || defined(WIN32)
# include <sys/types.h>
#endif

#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif /* HAVE_SYS_SOCKET_H */

#include <onion/DavSocketIORaw.h>
#include <onion/DavSocket.h>
#include <onion/DavWorkSession.h>
#include <errno.h>

CDavSocketIORaw::CDavSocketIORaw(void)
{
}

CDavSocketIORaw::~CDavSocketIORaw(void)
{
}

OI_RESULT 
CDavSocketIORaw::Readable(CDavSocket* pSocket, int nSecs)
{
  int nRet;
  fd_set rdfds;
  int s = pSocket->GetHandle();
  struct timeval timeout, *tvp = (nSecs >= 0 ? &timeout : 0);

  /* Init the fd set */
  FD_ZERO(&rdfds);
  do{
    FD_SET(s, &rdfds);
    if (tvp){
      tvp->tv_sec = nSecs;
      tvp->tv_usec = 0;
    }
    //the first parameter of "select" is IGNORED on Windows platforms
    //it was merely here for compatibility with the past
    nRet = ::select(s + 1, &rdfds, 0, 0, tvp);
  } while (nRet < 0 && onion_errno == ONION_EINTR);
  // MSDN said return value would be SOCKET_ERROR if select failed.
  // Anyway, it is a negative value
  if (nRet < 0){
    //TODO: detailed error infomation?
    return OISEREADFAILED;
  }
  if(nRet == 0){
    return OISETIMEOUT;
  } else {
    return OI_OK;
  }
}

OI_RESULT 
CDavSocketIORaw::Read(CDavSocket* pSocket,
		      char* pszBuf,
		      size_t* punReadLen,
		      int nSecs)
{
  OI_RESULT enuRet;
  int nBytes;
  size_t unBufLen = *punReadLen;
  int s = pSocket->GetHandle();
  enuRet = Readable(pSocket, nSecs);
  if(OI_OK != enuRet)
    return enuRet;
  do{
    nBytes = ONION_READ(s, pszBuf, unBufLen);
  } while(nBytes == ONION_SOCKERR 
	  && onion_errno == ONION_EINTR);

  if(nBytes == 0){
    //pSocket->setError(OISECLOSED);
    //??? add method to socket to relay?
    pSocket->m_pSession->Disconnect();
    return OISECLOSED;
  } else if(nBytes < 0) {
    int nErrNo = onion_errno;
    if(ONION_ISRESET(nErrNo)){
      return OISERESET;
    }
    return OISEGEN;
  } else {
    //TRACE("Rawread: %d chars read from raw socket\n", nBytes);
    *punReadLen = nBytes;
    return OI_OK;
  }
}

OI_RESULT 
CDavSocketIORaw::Write(CDavSocket* pSocket,
		       const char* pszBuf,
		       size_t* punWrittenLen)
{
  OI_ASSERT(pszBuf && punWrittenLen);

  size_t unBufLen = *punWrittenLen;
  int nBytes;
  int s = pSocket->GetHandle();
  do{
    nBytes = ONION_WRITE(s, pszBuf, unBufLen);
    pszBuf += nBytes;
    unBufLen -= nBytes;
  } while((nBytes > 0 || onion_errno == ONION_EINTR) && unBufLen > 0);

  if(nBytes < 0){
    int nErrNo = onion_errno;
    pSocket->m_pSession->Disconnect();
    if(ONION_ISRESET(nErrNo)){
      return OISERESET;
    }
    /*		
	switch(nErrNo){
	case WSAECONNRESET:
	  return OISERESET;
	case WSAECONNABORTED:
	  pSocket->m_pSession->Disconnect();
	  return OISECONNABORTED;
	default:
	  break;
	}
    */
    return OISEGEN;
  } else {
    *punWrittenLen = nBytes;
    return OI_OK;
  }
}

