/* 
   Input stream needed by input source
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavXmlInputStream.cpp 506 2016-09-27 07:49:57Z tfbuilder $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/DavXmlInputStream.h>
#include <onion/DavResponseBody.h>

CDavXmlInputStream::CDavXmlInputStream(CDavResponseBody* pBody):
  m_pBody(pBody),
  m_unByteCounter(0)
{
}

CDavXmlInputStream::~CDavXmlInputStream()
{
}

XMLSize_t
CDavXmlInputStream::readBytes(XMLByte* const toFill,
const XMLSize_t maxToRead)
{
  unsigned int unBytes = m_pBody->Read((unsigned char*)toFill, maxToRead);
  m_unByteCounter += unBytes;
  return unBytes;
}

XMLFilePos
CDavXmlInputStream::curPos() const
{
  return m_unByteCounter;
}

const XMLCh*
CDavXmlInputStream::getContentType() const
{
	return NULL;
}