/* 
   Input stream needed by input source
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavXmlInputStream.h 506 2016-09-27 07:49:57Z tfbuilder $
*/

#ifndef ONION_HEADER_DAVXMLINPUTSTREAM_H
#define ONION_HEADER_DAVXMLINPUTSTREAM_H 1

#include <onion/OnionCfg.h>
#include <xercesc/util/BinInputStream.hpp>

//forward declarations
class CDavResponseBody;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavXmlInputStream : public XNS(BinInputStream)
{
 public: 
  CDavXmlInputStream(CDavResponseBody* pBody);
  virtual ~CDavXmlInputStream();

  virtual XMLSize_t readBytes(XMLByte* const toFill,
	  const XMLSize_t maxToRead);
  virtual XMLFilePos curPos() const;
  virtual const XMLCh* getContentType() const;

private:
  CDavResponseBody* m_pBody;
  size_t m_unByteCounter;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVXMLINPUTSTREAM_H*/
