/* 
   SAX-DOM hybrid mode XML parser
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavXmlParser.cpp 553 2016-10-27 07:11:55Z tfbuilder $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/DavXmlParser.h>
#include <onion/PBCSMXml.h>

CDavXmlParser::CDavXmlParser(CPBCSMXml* pConsumer, const char* pszCutElement):
  m_pConsumer(pConsumer)
{
  OI_ASSERT(pConsumer);
  if(pszCutElement)
    m_strCutElement = pszCutElement;
}

CDavXmlParser::~CDavXmlParser()
{
}


void 
CDavXmlParser::endElement(const XNS(XMLElementDecl) &elemDecl, 
			  const unsigned int urlId, 
			  const bool isRoot, 
			  const XMLCh *const elemPrefix)
{
  AbstractDOMParser::endElement(elemDecl, urlId, isRoot,elemPrefix);
  if(m_strCutElement.empty()) return;
  if(! m_strCutElement.compare(X(elemDecl.getBaseName()))){
    XNS(DOMNode)* pNode = getCurrentNode();
    //TODO: for performance's sake, do a test to see which one is faster
    const XMLCh* pszNS =pNode->lookupNamespaceURI(elemPrefix);
    //OI_STRING_A strNS = X(pNode->lookupNamespaceURI(elemPrefix));
    //check the namespace uri to make sure it's a dav response
    //if(! strNS.compare("DAV:"))
    if(XNS(XMLString)::compareString(pszNS, X("DAV:")) == 0){
      m_pConsumer->OnResponseFound(pNode);
      pNode->getParentNode()->removeChild(pNode);
      pNode->release();
    }
  }
}

void 
CDavXmlParser::error(const unsigned int errCode, 
		     const XMLCh *const errDomain, 
		     const ErrTypes type, 
		     const XMLCh *const errorText, 
		     const XMLCh *const systemId, 
		     const XMLCh *const publicId, 
		     const XMLSSize_t lineNum, 
		     const XMLSSize_t colNum)
{
  int nCode = errCode;
}

void 
CDavXmlParser::docCharacters(const XMLCh *const chars, 
			     const unsigned int length, 
			     const bool cdataSection)
{
//  if(!XNS(XMLString)::isAllWhiteSpace(chars)){
	if (!XNS(XMLChar1_0)::isAllSpaces(chars, XNS(XMLString)::stringLen(chars))) {
		  AbstractDOMParser::docCharacters(chars,
				     length, 
				     cdataSection);
    }
}
