/* 
   SAX-DOM hybrid mode XML parser
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavXmlParser.h 554 2016-10-27 07:14:02Z tfbuilder $
*/

#ifndef ONION_HEADER_DAVXMLPARSER_H
#define ONION_HEADER_DAVXMLPARSER_H 1

#include <onion/OnionCfg.h>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/util/XMLChar.hpp>

//forward declarations
class CPBCSMXml;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavXmlParser : public XNS(XercesDOMParser)
{
 public:
  CDavXmlParser(CPBCSMXml* pConsumer, const char* pszCutElement = NULL);
  ~CDavXmlParser();

  void error (const unsigned int errCode,
	      const XMLCh *const errDomain,
	      const ErrTypes type,
	      const XMLCh *const errorText,
	      const XMLCh *const systemId,
	      const XMLCh *const publicId,
	      const XMLSSize_t lineNum,
	      const XMLSSize_t colNum);
  virtual void docCharacters (const XMLCh *const chars,
			      const unsigned int length,
			      const bool cdataSection);
  virtual void endElement(const XNS(XMLElementDecl)& elemDecl, 
			  const unsigned int urlId, 
			  const bool isRoot, 
			  const XMLCh* const elemPrefix);

 private:
  OI_STRING_A m_strCutElement;
  CPBCSMXml* m_pConsumer;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVXMLPARSER_H*/
