/* 
   Http header handler for "Auth"
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: HandlerAuth.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/HandlerAuth.h>
#include <onion/DavAuthSession.h>
#include <onion/DavRequest.h>
#include <onion/PBCSMAuthDigest.h>
#include <onion/PBCSMAuthBasic.h>

CHandlerAuth::CHandlerAuth(CDavAuthSession* pAuthSession)
{
  OI_ASSERT(pAuthSession);
  m_pAuthSession = pAuthSession;
  /*m_pPBConsumer = NULL;*/
}

CHandlerAuth::~CHandlerAuth()
{
  /*if(m_pPBConsumer) delete m_pPBConsumer;*/
}

OI_RESULT 
CHandlerAuth::Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues)
{
  /*TODO: add scheme sequence logic*/
  return m_pAuthSession->ParseAuthHeader(vecValues[0].c_str());

  /*
  if(m_pAuthSession->GetAuthScheme() == H_AUTH_BASIC){
    if(m_pPBConsumer) delete m_pPBConsumer;
    m_pPBConsumer = new CPBCSMAuthBasic(pReq);
  } else {
    if(m_pPBConsumer) delete m_pPBConsumer;
    m_pPBConsumer = new CPBCSMAuthDigest(pReq);
  }
  */
  //  return OI_OK;
}

const char* 
CHandlerAuth::GetHeaderName()
{
  return m_pAuthSession->GetAuthHeaderName();
}

