/* 
   Http header handler for "Content-Length"
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: HandlerCLength.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#include <onion/HandlerCLength.h>
#include <onion/DavRequest.h>
#include <onion/DavResponseBody.h>

CHandlerCLength::CHandlerCLength(CDavResponseBody* pBody)
{
  m_pBody = pBody;
}

CHandlerCLength::~CHandlerCLength()
{
}

OI_RESULT 
CHandlerCLength::Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues)
{
  char* pchPos = 0;
  OI_SIZE_T unBodyLen = OI_STRTOUL(vecValues[0].c_str(), &pchPos, 10);
  if(
#ifndef _FILE_OFFSET_BITS
     unBodyLen != ULONG_MAX && 
#endif
     m_pBody->m_enuMode == M_RSP_TILLEOF){
    m_pBody->m_enuMode = M_RSP_CLENGTH;
    m_pBody->m_unBodyLen = unBodyLen;
    m_pBody->m_unBodyLeft = unBodyLen;
  }
  return OI_OK;
}

const char* 
CHandlerCLength::GetHeaderName()
{
  return OI_RSPHDR_CLENGTH;
}

