/* 
   Http header handler for "Content-Range"
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: HandlerCRange.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/HandlerCRange.h>
#include <onion/DavRequest.h>


CHandlerCRange::CHandlerCRange(OICRANGE* pCRange)
  :m_pCRange(pCRange)
{
  OI_ASSERT(pCRange);
}

CHandlerCRange::~CHandlerCRange()
{
}

/**
 * parse response header "Content-Range"
 *  format: "nStart - nEnd / nTotal"
 * this is only for user output, nothing important here
 */
OI_RESULT 
CHandlerCRange::Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues)
{
  if(vecValues.size() < 1)
    return OIHEMALFORMEDHEADER;

  OI_STRING_A strCRange = vecValues[0];
  OI_STRING_A strStart, strEnd, strTotal;
  OI_STRING_A::size_type nDashPos, nSlashPos, nEndPos;
  int nLen = strCRange.length();
  m_pCRange->nStart = -1;
  m_pCRange->nEnd = -1;
  m_pCRange->nTotal = -1;

  if(nLen < 5)
    return OIHEMALFORMEDHEADER;

  nEndPos = (OI_STRING_A::size_type)(nLen - 1);

  nDashPos = strCRange.find('-');
  if((OI_STRING_A::npos == nDashPos) || 
     (nDashPos < 1) ||
     (nDashPos >= nEndPos))
    /*malformed header*/
    return OIHEMALFORMEDHEADER;

  nSlashPos = strCRange.find('/');
  if((nSlashPos <= (nDashPos + 1)) || (nSlashPos >= nEndPos))
    /*malformed header*/
    return OIHEMALFORMEDHEADER;

  strStart = strCRange.substr(0, nDashPos - 1);
  TrimLeftA(strStart);
  TrimRightA(strStart);
  
  strEnd = strCRange.substr(nDashPos + 1, nSlashPos - 1);
  TrimLeftA(strEnd);
  TrimRightA(strEnd);

  strTotal = strCRange.substr(nSlashPos + 1);
  TrimLeftA(strTotal);
  TrimRightA(strTotal);

  char* pchPos = NULL;
  m_pCRange->nStart = OI_STRTOUL(strStart.c_str(), &pchPos, 10);
  m_pCRange->nEnd = OI_STRTOUL(strEnd.c_str(), &pchPos, 10);
  m_pCRange->nTotal = OI_STRTOUL(strTotal.c_str(), &pchPos, 10);

  return OI_OK;
}

const char* 
CHandlerCRange::GetHeaderName()
{
  return OI_RSPHDR_CRANGE;
}

