/* 
   Http header handler for "Connection"
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: HandlerConn.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/HandlerConn.h>
#include <onion/DavRequest.h>

CHandlerConn::CHandlerConn(void)
{
}

CHandlerConn::~CHandlerConn(void)
{
}


OI_RESULT 
CHandlerConn::Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues)
{
  if(vecValues.size() < 1)
    return OIHEMALFORMEDHEADER;

  OI_STRING_A strValue = vecValues[0];
  OI_STRING_A strClose = "close";
  OI_STRING_A strKeepAlive = "Keep-Alive";

  MakeLowerA(strValue);
  MakeLowerA(strClose);
  MakeLowerA(strKeepAlive);

  if(strValue == strClose){
    pReq->SetPersistent(false);
  } else if(strValue == strKeepAlive) {
    pReq->SetPersistent(true);
  }
  return OI_OK;
}

const char* 
CHandlerConn::GetHeaderName()
{
  return OI_RSPHDR_CONN;
}

