/* 
   Http header handler for "Keep-Alive"
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: HandlerKeepAlive.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/HandlerKeepAlive.h>
#include <onion/DavRequest.h>
#include <onion/DavWorkSession.h>

CHandlerKeepAlive::CHandlerKeepAlive(void)
{
}

CHandlerKeepAlive::~CHandlerKeepAlive(void)
{
}

OI_RESULT
CHandlerKeepAlive::Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues)
{
  //OI_DEBUG("value : %s\n", pszValue);
  CDavStringTokenizer tokKeepAlive(vecValues[0].c_str(), ", ");
  OI_STRING_A strField;
  OI_STRING_A strName;
  OI_STRING_A strValue;
  for(;tokKeepAlive.GetNextToken(strField);){
    CDavStringTokenizer tokField(strField.c_str(), "= ");
    if(!tokField.GetNextToken(strName))
      continue;
    if(!tokField.GetNextToken(strValue))
      continue;
    MakeLowerA(strName);
    if(strName == "timeout"){
      long nTimeout = atol(strValue.c_str());
      time_t tmNow = time(NULL);
      pReq->GetSession()->m_tmConnectionTTL = tmNow + nTimeout;
    } else if(strName == "max"){
      int nMax = atoi(strValue.c_str());
      pReq->GetSession()->m_nMaxConnections = nMax;
    }
  }
  return OI_OK;
}

const char*
CHandlerKeepAlive::GetHeaderName()
{
  return OI_RSPHDR_KEEPALIVE;
}
