/* 
   Http header handler for "Transfer-Encoding"
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: HandlerTE.cpp 132 2005-06-24 09:09:43Z komat $
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <string.h>
#include <onion/HandlerTE.h>
#include <onion/DavRequest.h>
#include <onion/DavResponseBody.h>

CHandlerTE::CHandlerTE(CDavResponseBody* pBody)
{
  m_pBody = pBody;
}

CHandlerTE::~CHandlerTE(void)
{
}

OI_RESULT 
CHandlerTE::Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues)
{
  if(vecValues.size() < 1)
    return OI_OK;
 
  OI_STRING_A strValue = vecValues[0];
  MakeLowerA(strValue);
  if(strValue.compare("chunked") == 0){
    m_pBody->m_enuMode = M_RSP_CHUNKED;
    m_pBody->m_unChunkLeft = 0;
  }
  return OI_OK;
}

const char* 
CHandlerTE::GetHeaderName()
{
  return OI_RSPHDR_TE;
}
