/* 
   Response body consumer in case of basic authentication
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: PBCSMAuthBasic.cpp 132 2005-06-24 09:09:43Z komat $
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/PBCSMAuthBasic.h>
#include <onion/DavRequest.h>
#include <onion/DavResponseBody.h>
#include <onion/DavWorkSession.h>

CPBCSMAuthBasic::CPBCSMAuthBasic(CDavRequest* pReq):
  CResponseBodyConsumer(pReq)
{
}

CPBCSMAuthBasic::~CPBCSMAuthBasic()
{
}

void
CPBCSMAuthBasic::Close()
{
}

OI_RESULT
CPBCSMAuthBasic::Open()
{
  return OI_OK;
}

OI_PBC_TYPE
CPBCSMAuthBasic::GetType()
{
  return T_PBC_DUMMY;
}

OI_RESULT 
CPBCSMAuthBasic::PullResponseBody(CDavResponseBody* pBody)
{
  OI_RESULT enuRet;
  size_t unReadLen, unBufLen = OI_GENBUFSIZE;
  bool bCLength = (pBody->m_enuMode == M_RSP_CLENGTH);
  CDavWorkSession* pSession = m_pRequest->GetSession();
  bool bContinue;

  OI_ASSERT(pSession);
  char* pszBuf = m_pRequest->m_szBuffer;
  for(enuRet = OI_RETRY; enuRet == OI_RETRY;){
    enuRet = pBody->Read(pszBuf, unBufLen, &unReadLen);
    bContinue = pSession->OnReceiveProgress(m_pRequest,
					    pBody->m_unReadLen,
					    pBody->m_unBodyLen,
					    bCLength);
    if(!bContinue){
      pSession->Disconnect();
      return OI_USERCANCELED;
    }
    //unReadLen = OI_GENBUFSIZE;
  }
  return enuRet;
}

