/* 
   Response body consumer that writes to a local file
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: PBCSMLocalFile.cpp 132 2005-06-24 09:09:43Z komat $
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/PBCSMLocalFile.h>
#include <onion/DavRequest.h>
#include <onion/DavResponseBody.h>
#include <onion/DavWorkSession.h>

#ifdef WIN32
#  include <io.h>
#elif defined(HAVE_UNISTD_H)
#  include <unistd.h>
#endif /*HAVE_UNISTD_H*/

CPBCSMLocalFile::CPBCSMLocalFile(CDavRequest* pReq, int nHandle):
  CResponseBodyConsumer(pReq),
  m_nHandle(nHandle)
{
  OI_ASSERT(nHandle);
  //m_lPosition = tell(nHandle);
}

CPBCSMLocalFile::~CPBCSMLocalFile()
{
}

void
CPBCSMLocalFile::Close()
{
}

OI_RESULT
CPBCSMLocalFile::Open()
{
  return OI_OK;
}

OI_PBC_TYPE
CPBCSMLocalFile::GetType()
{
  return T_PBC_FILE;
}

OI_RESULT 
CPBCSMLocalFile::PullResponseBody(CDavResponseBody* pBody)
{
  OI_RESULT enuRet;
  bool bContinue;
  size_t unReadLen, unBufLen;
  char* pszBuf = m_pRequest->m_szBuffer;	//we use request buffer here
  CDavWorkSession* pSession = m_pRequest->GetSession();
  OI_ASSERT(pSession);

  for(enuRet = OI_RETRY, unBufLen = OI_GENBUFSIZE;
      enuRet == OI_RETRY;
      unReadLen = OI_GENBUFSIZE){
    enuRet = pBody->Read(pszBuf, unBufLen, &unReadLen);
    if(enuRet != OI_OK && enuRet != OI_RETRY)
      return enuRet;
    
    //increment session progress and query for continue
    bContinue = 
      pSession->OnReceiveProgress(m_pRequest,
				  pBody->m_unReadLen,
				  pBody->m_unBodyLen, 
				  (pBody->m_enuMode == M_RSP_CLENGTH));
    if(!bContinue){
      pSession->Disconnect();
      return OI_USERCANCELED;
    }

    //TODO:error handling
    write(m_nHandle, pszBuf, unReadLen);
  }
  return enuRet;
}

