/* 
   Response body consumer that writes to memory buffer
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: PBCSMMemBuffer.cpp 132 2005-06-24 09:09:43Z komat $
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/PBCSMMemBuffer.h>
#include <onion/DavRequest.h>
#include <onion/DavResponseBody.h>
#include <onion/DavWorkSession.h>
#include <onion/DavMemBuffer.h>

CPBCSMMemBuffer::CPBCSMMemBuffer(CDavRequest* pReq):
  CResponseBodyConsumer(pReq)
{
}

CPBCSMMemBuffer::~CPBCSMMemBuffer()
{
}

void
CPBCSMMemBuffer::Close()
{
}

OI_RESULT
CPBCSMMemBuffer::Open()
{
  return OI_OK;
}

OI_PBC_TYPE
CPBCSMMemBuffer::GetType()
{
  return T_PBC_BUFFER;
}


OI_RESULT 
CPBCSMMemBuffer::PullResponseBody(CDavResponseBody* pBody)
{
  size_t unReadLen, unBufLen = OI_GENBUFSIZE;
  OI_RESULT enuRet;
  bool bContinue;

  char* pszBuf = m_pRequest->m_szBuffer;	//use request's internal buffer
  CDavWorkSession* pSession = m_pRequest->GetSession();
  CDavMemBuffer* pMemBuffer = pSession->GetMemBuffer();
  pMemBuffer->m_strContentType = pBody->m_strContentType;

  for(enuRet = OI_RETRY; enuRet == OI_RETRY;){
    enuRet = pBody->Read(pszBuf, unBufLen, &unReadLen);
    bContinue = pSession->OnReceiveProgress(m_pRequest, 
					    pBody->m_unReadLen,
					    pBody->m_unBodyLen,
					    (pBody->m_enuMode == M_RSP_CLENGTH));
    if(!bContinue){
      //TODO: better cancel handling
      pSession->Disconnect();
      return OI_USERCANCELED;
    }
    pMemBuffer->Write(pszBuf, unReadLen);
  }
  return enuRet;
}

