/* 
   Response body consumer that parses body as an XML stream
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: PBCSMXml.cpp 132 2005-06-24 09:09:43Z komat $
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/PBCSMXml.h>
#include <onion/DavRequest.h>
#include <onion/DavResponseBody.h>
#include <onion/DavWorkSession.h>
#include <onion/DavXmlErrorHandler.h>
#include <onion/DavXmlInputSource.h>
#include <onion/DavXmlParser.h>
#include <onion/DavXmlBuffer.h>
#include <onion/Utils.h>

CPBCSMXml::CPBCSMXml(CDavRequest* pReq, 
		     const char* pszCutElement, 
		     CDavXmlBuffer* pXmlReceiver):
  CResponseBodyConsumer(pReq),
  m_pXmlReceiver(pXmlReceiver)
{
  m_nResponseCounter = 0;
  m_enuError = OI_OK;
  m_pErrorHandler = NULL;
  m_pXmlParser = NULL;
  try{
    m_pErrorHandler = new CDavXmlErrorHandler;
    m_pXmlParser = new CDavXmlParser(this, pszCutElement);
    m_pXmlParser->setDoNamespaces(true);
    m_pXmlParser->setIncludeIgnorableWhitespace(false);    // optional
    m_pXmlParser->setExitOnFirstFatalError(true);
    m_pXmlParser->setErrorHandler(m_pErrorHandler);
  } catch(...) {
    m_enuError = OIXEPARSERCREATION;
  }
}

CPBCSMXml::~CPBCSMXml()
{
  try{
    if(m_pXmlParser)
      delete m_pXmlParser;
    if(m_pErrorHandler)
      delete m_pErrorHandler;
  } catch(...) {
  }
}

void
CPBCSMXml::Close()
{
}

OI_RESULT
CPBCSMXml::Open()
{
  return OI_OK;
}

OI_PBC_TYPE
CPBCSMXml::GetType()
{
  return T_PBC_XML;
}

XNS(DOMDocument)*
CPBCSMXml::GetDocument()
{
  return m_pXmlParser->getDocument();
}

OI_RESULT
CPBCSMXml::CheckCType(const char* pszCType)
{
  OI_ASSERT(pszCType);
  OI_STRING_A strCType = pszCType;
  TrimLeftA(strCType);
  MakeLowerA(strCType);
  if(strncmp(strCType.c_str(), "text/xml", 7) == 0) {
    return OI_OK;
  } else {
    return OIDECTYPEMISMATCH;
  }
}

OI_RESULT
CPBCSMXml::PullResponseBody(CDavResponseBody* pBody)
{
  /*make sure parser is OK*/
  if(OI_OK != m_enuError)
    return m_enuError;
  CDavXmlInputSource inputSource(pBody);
  CDavWorkSession* pSession = m_pRequest->GetSession();
  try{
    m_pXmlParser->parse(inputSource);
    //m_pXmlParser->parse("f:\\resp.xml");
  } catch(XNS(DOMException) e) { 
    //DOMException
    X strMsg = e.msg;
    OI_DEBUG("DOMException:%s\n", (const char*)strMsg);
    pSession->m_strErrorDescription = (const char*)strMsg;
    m_enuError = OIXEEXCEPTION;
  } catch(XNS(SAXException) e) { 
    //SAXException
    X strMsg = e.getMessage();
    OI_DEBUG("SAXException:%s\n", (const char*)strMsg);
    pSession->m_strErrorDescription = (const char*)strMsg;
    m_enuError = OIXEEXCEPTION;
  } catch(...) {
    //unknown exceptions
    X strMsg = "Unknown exception";
    OI_DEBUG("Unknown Exception:%s\n", (const char*)strMsg);
    pSession->m_strErrorDescription = (const char*)strMsg;
    m_enuError = OIXEEXCEPTION;
  }
  if((OI_OK != m_enuError) && (OI_OK == pBody->m_enuLastErr)) {
    pBody->m_enuLastErr = m_enuError;
  }

  OI_DEBUG("[ %d ] response(s) found \n", m_nResponseCounter);
  return pBody->m_enuLastErr;
}

void
CPBCSMXml::OnResponseFound(XNS(DOMNode)* pNode)
{
  ++ m_nResponseCounter;
  if(m_pXmlReceiver){
    m_pXmlReceiver->AppendChild((XNS(DOMElement)*)pNode);
  } else {
    m_pRequest->GetSession()->onResponseFound(m_pRequest, pNode);
  }
}

