/* 
   Request body provider that provides body from a local file
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: RBPVDLocalFile.cpp 132 2005-06-24 09:09:43Z komat $
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/RBPVDLocalFile.h>

#if defined(HAVE_SYS_TYPES_H) || defined(WIN32)
#include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#if defined(HAVE_SYS_STAT_H) || defined(WIN32)
#include <sys/stat.h>
#endif /* HAVE_SYS_STAT_H */

#ifdef WIN32
#include <io.h>
#elif defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/

#include <stdlib.h>

CRBPVDLocalFile::CRBPVDLocalFile(int nHandle):
  m_nHandle(nHandle)
{
  OI_ASSERT(nHandle);
}

CRBPVDLocalFile::~CRBPVDLocalFile()
{
}

OI_RBP_TYPE
CRBPVDLocalFile::GetType()
{
  return T_RBP_FILE;
}

void
CRBPVDLocalFile::Close()
{
}

OI_RESULT
CRBPVDLocalFile::Open()
{
  return OI_OK;
}

void
CRBPVDLocalFile::OnCancel(CDavRequest* pReq)
{
}

OI_SIZE_T
CRBPVDLocalFile::GetBodyLength()
{
#ifdef OI_USESTAT64
  struct stat64 st;
#elif defined(WIN32)
  struct _stati64 st;
#else
  struct stat st;
#endif
  OI_FSTAT(m_nHandle, &st);
  return st.st_size;
}

OI_RESULT
CRBPVDLocalFile::Rewind()
{
  lseek(m_nHandle, 0, SEEK_SET);
  return OI_OK;
}

OI_RESULT
CRBPVDLocalFile::Read(CDavRequest* pReq, char* pszBuf, size_t* punReadLen)
{
  size_t unReadLen = *punReadLen;	//buffer length

  //TODO: IO error handling
  unReadLen = read(m_nHandle, pszBuf, unReadLen);
  *punReadLen = unReadLen;

  if(unReadLen > 0)
    return OI_RETRY;
  else
    return OI_OK;
}

