/* 
   Request body provider that provides XML contents
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: RBPVDXml.h 506 2016-09-27 07:49:57Z tfbuilder $
*/


#ifndef ONION_HEADER_RBPVDXML_H
#define ONION_HEADER_RBPVDXML_H 1

#include <onion/OnionCfg.h>
#include <onion/RequestBodyProvider.h>
#include <onion/DavXmlBuffer.h>

#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMElement.hpp>
#include <xercesc/framework/MemBufFormatTarget.hpp>

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CRBPVDXml : public CRequestBodyProvider
{
 public:
  CRBPVDXml(const char* pszDocName = OI_XML_PROPFINDDOCNAME);
  virtual ~CRBPVDXml();

  virtual OI_RBP_TYPE GetType();
  virtual void Close();
  virtual OI_RESULT Open();
  virtual OI_RESULT Rewind();
  virtual OI_SIZE_T GetBodyLength();
  virtual void OnCancel(CDavRequest* pReq);
  virtual OI_RESULT Read(CDavRequest* pReq,
			 char* pszBuf,
			 size_t* punReadLen);

  void AddRootElement(const char* pszNS, const char* pszName);
  void AddNamespaceMapping(const char* pszPrefix, const char* pszURI);
  void SetDocumentName(const char* pszName);
  bool Load(const char* pszPath);
  bool Load(CDavXmlBuffer* pXmlBuffer);
 protected:
  void GenerateXml();

 protected:
  CDavXmlBuffer m_xbfBody;
  char* m_pszBuf;

  size_t m_unBufLen;
  size_t m_unCurPos;
 private:

//  XNS(DOMWriter)* m_pDomWriter;
  XNS(DOMLSSerializer)* m_lpDomSSerializer;
  XNS(DOMLSOutput)* m_lpOutput;
  XNS(MemBufFormatTarget)* m_pFormatTarget;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_RBPVDXML_H*/
