/* 
   Request body provider that provides XML for LOCK method
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: RBPVDXmlLock.cpp 132 2005-06-24 09:09:43Z komat $
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <onion/RBPVDXmlLock.h>
#include <onion/DavLock.h>

CRBPVDXmlLock::CRBPVDXmlLock(CDavLock* pLock):
  CRBPVDXml(OI_XML_LOCKDOCNAME)
{
  OI_ASSERT(pLock);
  OI_STRING_A strType;
  OI_STRING_A strScope;

  switch(pLock->m_enuType){
  case T_LOCK_WRITE:
  default:
    strType = "D:write";
  }

  switch(pLock->m_enuScope){
  case SCP_LOCK_SHARED:
    strScope = "D:shared";
    break;
  case SCP_LOCK_EXCLUSIVE:
  default:
    strScope = "D:exclusive";
    break;
  }

  X strDavNS(OI_XML_DAVNAMESPACE);
  const XMLCh* pszDavNS = strDavNS;

  XNS(DOMDocument)* pDoc = m_xbfBody.GetDocument();

  //TODO: put the hard coded element names into def?
  XNS(DOMElement)* pRoot = pDoc->getDocumentElement();
  //DAV:lockscope
  XNS(DOMElement)* pScope = pDoc->createElementNS(pszDavNS,
						  X("D:lockscope"));
  pRoot->appendChild(pScope);
  XNS(DOMElement)* pScopeVal = pDoc->createElementNS(pszDavNS,
						     X(strScope.c_str()));
  pScope->appendChild(pScopeVal);
  //DAV:lockscope
  XNS(DOMElement)* pType = pDoc->createElementNS(pszDavNS,
						 X("D:locktype"));
  pRoot->appendChild(pType);
  XNS(DOMElement)* pTypeVal = pDoc->createElementNS(pszDavNS,
						    X(strType.c_str()));
  pType->appendChild(pTypeVal);
  //DAV:owner
  XNS(DOMElement)* pOwner = pDoc->createElementNS(pszDavNS,
						  X("D:owner"));
  pRoot->appendChild(pOwner);
  if(pLock->m_pOwner){
    XNS(DOMNode)* pOwnerVal;
    OI_ASSERT(pDoc != pLock->m_pOwner->getOwnerDocument());
    //this is not likely to happen
    pOwnerVal = pDoc->importNode(pLock->m_pOwner, true);
    pOwner->appendChild(pOwnerVal);
  } else {
    //default owner node
    XNS(DOMNode)* pOwnerDefault = pDoc->createElementNS(pszDavNS,
							X("D:href"));
    pOwner->appendChild(pOwnerDefault);
    XNS(DOMNode)* pOwnerTxt = pDoc->createTextNode(X(OI_XML_DEFAULTLOCKOWNER));
    pOwnerDefault->appendChild(pOwnerTxt);
  }
}

CRBPVDXmlLock::~CRBPVDXmlLock()
{
}
