/* 
   Prototype of http response body consumer
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: ResponseBodyConsumer.h 132 2005-06-24 09:09:43Z komat $
*/


#ifndef ONION_HEADER_RESPONSEBODYCONSUMER_H
#define ONION_HEADER_RESPONSEBODYCONSUMER_H 1

#include <onion/OnionCfg.h>

//forward declarations
class CDavRequest;
class CDavResponseBody;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CResponseBodyConsumer
{
  friend class CDavRequest;
 public:
  CResponseBodyConsumer(CDavRequest* pReq);
  virtual ~CResponseBodyConsumer(void);
  virtual OI_RESULT CheckCType(const char *pszCType);
  virtual OI_RESULT PullResponseBody(CDavResponseBody* pBody)=0;
  virtual void Close() = 0;
  virtual OI_RESULT Open() = 0;
  virtual OI_PBC_TYPE GetType() = 0;
  virtual void OnCancel(CDavRequest* pReq);
 protected:
  CDavRequest* m_pRequest;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_RESPONSEBODYCONSUMER_H*/
