/* 
   Utility functions
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: Utils.h 132 2005-06-24 09:09:43Z komat $
*/


#ifndef ONION_HEADER_UTILS_H
#define ONION_HEADER_UTILS_H 1

#include <onion/OnionCfg.h>
#include <time.h>
#include <openssl/x509.h>

//forward declarations
class CDavSSLCertificate;
class CDavSSLCertificateList;
class CDavSSLClientCertificate;

typedef void (*OSSLLOCKCALLBACK)(int nMode,
				 int nType,
				 const char *pszFile,
				 int nLine);
typedef void (*ONIONDEBUGLOCKCALLBACK)(const char *pszFile,
				       int nLine);

OI_BEGIN_CPPFUNCTIONEXPORT

extern OI_EXPORT OI_RESULT OnionInitialize(OSSLLOCKCALLBACK sslLockCallback = NULL);
extern OI_EXPORT void OnionTerminate();
extern OI_EXPORT int OnionNumOfLocks();
extern OI_EXPORT void OnionSetDebugLockCallback(ONIONDEBUGLOCKCALLBACK debugLockCallback);
extern OI_EXPORT OI_RESULT OnionRedirectDebugOutput(const char* pszPath,
					  const char* pszMode = "w");
extern OI_EXPORT void OnionDebugOutput(const char* pszFormat, ...);
extern OI_EXPORT void OnionSetDebugOptions(unsigned int unOptions);
extern OI_EXPORT const char* GetErrorDescription(OI_RESULT enuResult);

extern OI_EXPORT void MakeLowerA(OI_STRING_A& strAnsi);
extern OI_EXPORT void MakeUpperA(OI_STRING_A& strAnsi);
extern OI_EXPORT void TrimLeftA(OI_STRING_A& strAnsi);
extern OI_EXPORT void TrimRightA(OI_STRING_A& strAnsi);
extern OI_EXPORT OI_STRING_A Utf8ToAnsi(const OI_STRING_A& sUtf8);
extern OI_EXPORT OI_STRING_A AnsiToUtf8(const OI_STRING_A& sAnsi);
extern OI_EXPORT OI_STRING_A Unescape(const OI_STRING_A& uri);
extern OI_EXPORT OI_STRING_A Escape(const OI_STRING_A& uri);
extern OI_EXPORT OI_STRING_A Base64Encode(const OI_STRING_A& input);
extern OI_EXPORT OI_STRING_A Base64Decode(const OI_STRING_A& input);
/*MD5 hash for strings*/
extern OI_EXPORT void MD5Hash(const void* pvData,
			     unsigned long unSize,
			     OI_STRING_A& output);
extern OI_EXPORT void MD5HashString(const OI_STRING_A& input, OI_STRING_A& output);

extern OI_EXPORT time_t ParseTime(const char* pszTime);
extern OI_EXPORT time_t ParseTimeASC(const char* pszTime);
extern OI_EXPORT time_t ParseTimeISO8601(const char* pszTime);
extern OI_EXPORT time_t ParseTimeRFC1036(const char* pszTime);
extern OI_EXPORT time_t ParseTimeRFC1123(const char* pszTime);
extern OI_EXPORT time_t ParseTimeRFC2459(const char* pszTime);
extern OI_EXPORT time_t GmtToLocal(time_t gmt);

OI_END_CPPFUNCTIONEXPORT

/* ssl certificate functions */
typedef void (*SSLCERTLOADCALLBACK)(X509* pX509, void* pvUserData);

OI_BEGIN_CPPFUNCTIONEXPORT

extern OI_EXPORT int ReadCertificates(BIO* pBIO,
			    OI_SSL_CRTMSG enuMsgFormat,
			    OI_SSL_CRTENC enuEncForma,
			    SSLCERTLOADCALLBACK pfnCertCB,
			    void* pUser);
extern OI_EXPORT int LoadCertificates(const char* pszPath,
			    OI_SSL_CRTMSG enuMsgFormat,
			    OI_SSL_CRTENC enuEncForma);
extern OI_EXPORT int LoadCertificates(CDavSSLCertificateList* pList);
extern OI_EXPORT int LoadCertificate(CDavSSLCertificate* pCert);
extern OI_EXPORT void ClearCertificateStore();
extern OI_EXPORT bool LoadClientCertificate(CDavSSLClientCertificate* pCert);

OI_END_CPPFUNCTIONEXPORT

//light wrapper for tokenize function
//Warning: this class is intended for  local use only
//all pointers must remain valid during tokenization
//process
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavStringTokenizer
{
 public:
  CDavStringTokenizer(const char* pszInput, const char* pszDelimiters = " ");
  ~CDavStringTokenizer();
 private:
  bool m_bInQuote;
  const char* m_pszDelimiters;
  const char* m_pszCurrentPos;
  const char* m_pszHead;
 public:
  bool GetNextToken(OI_STRING_A& strOutput);
  void SetToken(const char* pszInput);
  void SetDelimiter(const char* pszDelimiter);
 private:
  bool IsDelimiter(char chInput);
};

OI_END_CLASSEXPORT

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavXmlString
{
 public:
  CDavXmlString();
  CDavXmlString(const CDavXmlString& master);
  CDavXmlString(const char* pszANSIStr);
  CDavXmlString(const XMLCh* pszXMLStr);
  CDavXmlString(const XMLByte* pszUTF8Str);
  ~CDavXmlString();
  void erase();
  unsigned int Length() const;
  OI_STRING_A UTF8();
  operator const char*();
  operator const XMLCh*();
  CDavXmlString& operator=(const CDavXmlString& master);
  CDavXmlString& operator=(const char* pszANSIStr);
  CDavXmlString& operator=(const XMLCh* pszXMLStr);
  CDavXmlString& operator=(const XMLByte* pszUTF8Str);
  CDavXmlString& toEscapedUTF8();
 private:
  void copy(const char* pszANSIStr);
  void copy(const XMLCh* pszXMLStr);
  void copy(const CDavXmlString& master);
  void transcode(const XMLByte* pszUTF8Str);
 private:
  XMLCh* m_pszXMLStr;
  char*	m_pszANSIStr;
};

OI_END_CLASSEXPORT

typedef CDavXmlString X;
#define CX2CA(x) (const char*)((X&)x)

#endif /*ONION_HEADER_UTILS_H*/
